/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.versionupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionBO;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionId;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionUpdateProcessBO;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionUpdateProcessStatus;
import de.justsoftware.drive.common.versionupdate.model.UpdateProcessId;
import de.justsoftware.drive.common.versionupdate.model.UpdateProcessorType;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import de.justsoftware.drive.persistence.versionupdate.DriveVersionDAO;
import de.justsoftware.drive.persistence.versionupdate.DriveVersionMapper;
import de.justsoftware.drive.persistence.versionupdate.VersionCreateModel;
import java.util.Collection;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DriveVersionDAOImpl
implements DriveVersionDAO {
    private final DriveVersionMapper _mapper;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public DriveVersionDAOImpl(DriveVersionMapper driveVersionMapper, TransactionSupport transactionSupport) {
        this._mapper = driveVersionMapper;
        this._transactionSupport = transactionSupport;
    }

    public DriveVersionId insertVersion(String driveVersion, Iterable<DriveVersionUpdateProcessBO> processes) {
        return (DriveVersionId)this._transactionSupport.doInTransaction(() -> {
            VersionCreateModel createModel = new VersionCreateModel(driveVersion);
            this._mapper.insert(createModel);
            this._transactionSupport.flushBatchStatements();
            DriveVersionId versionId = new DriveVersionId(createModel.getId());
            processes.forEach(p -> {
                p.setProcessId(UpdateProcessId.random());
                p.setDriveVersionId(versionId);
            });
            processes.forEach(arg_0 -> ((DriveVersionMapper)this._mapper).insertProcess(arg_0));
            return versionId;
        });
    }

    public DriveVersionBO getLatestVersion() {
        return this._mapper.getLastestVersion();
    }

    public void updateProcessStatus(UpdateProcessId processId, DriveVersionUpdateProcessStatus status) {
        this._mapper.updateProcess(processId, status);
    }

    public ImmutableMap<UpdateProcessorType, DriveVersionUpdateProcessBO> getLatestCompletedProcessesVersions() {
        return ImmutableMap.copyOf((Map)this._mapper.getLatestCompletedProcessesVersions());
    }

    public ImmutableList<DriveVersionUpdateProcessBO> getProcessesForVersion(DriveVersionId versionId, DriveVersionUpdateProcessStatus status) {
        return ImmutableList.copyOf((Collection)this._mapper.getProcessesForVersion(versionId, status));
    }
}

