/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.search.DocumentSearchResultEntryBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.person.model.PersonId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DocumentSearchResultBO {
    private final ImmutableList<DocumentSearchResultEntryBO> _resultEntries;
    private final long _numberOfResults;

    public DocumentSearchResultBO(ImmutableList<DocumentSearchResultEntryBO> resultEntries, long numberOfResults) {
        this._resultEntries = resultEntries;
        this._numberOfResults = numberOfResults;
    }

    @Nonnull
    public ImmutableList<DocumentSearchResultEntryBO> getResultEntries() {
        return this._resultEntries;
    }

    @Nonnull
    public ImmutableSet<DocumentId> getResultDocumentIds() {
        return FluentIterable.from((Iterable)this.getResultEntries()).transform(DocumentSearchResultEntryBO::getId).toSet();
    }

    @Nonnull
    public ImmutableSet<PersonId> getResultOwnerIds() {
        return FluentIterable.from((Iterable)this._resultEntries).transform(DocumentSearchResultEntryBO.TO_DOCUMENT_VERSION_BO).filter(FileVersionBO.class).transform(DocumentVersionBO.GET_OWNER).toSet();
    }

    @Nonnull
    public ImmutableSet<StorageId> getResultStorageIds() {
        return FluentIterable.from((Iterable)this._resultEntries).transform(DocumentSearchResultEntryBO.TO_DOCUMENT_VERSION_BO).filter(FileVersionBO.class).transform(FileVersionBO.GET_STORAGE_ID).toSet();
    }

    public long getNumberOfResults() {
        return this._numberOfResults;
    }
}

