/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.person;

import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.event.PersonUpdatedEvent;
import de.justsoftware.drive.business.person.PersonModificationService;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.person.PersonCreateModel;
import de.justsoftware.drive.persistence.person.PersonDAO;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionDAO;
import de.justsoftware.drive.persistence.sharesubscription.ShareSubscriptionDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonModificationServiceImpl
implements PersonModificationService {
    private final PersonDAO _personDAO;
    private final EventBus _eventBus;
    private final TransactionSupport _transactionSupport;
    private final ShareSubscriptionDAO _shareSubscriptionDAO;
    private final SharePermissionDAO _sharePermissionDAO;

    @Autowired
    public PersonModificationServiceImpl(PersonDAO personDAO, EventBus eventBus, TransactionSupport transactionSupport, ShareSubscriptionDAO shareSubscriptionDAO, SharePermissionDAO sharePermissionDAO) {
        this._personDAO = personDAO;
        this._eventBus = eventBus;
        this._transactionSupport = transactionSupport;
        this._shareSubscriptionDAO = shareSubscriptionDAO;
        this._sharePermissionDAO = sharePermissionDAO;
    }

    public void savePerson(PersonId personId, String email, String fullname, String firstname, String lastname, String imageUrl, String profileHash, boolean active, boolean blocked, boolean deleted, @Nullable String tenantIdString) {
        TenantId tenantId = TenantId.parse((String)tenantIdString).orElse(null);
        this._transactionSupport.doInTransaction(() -> {
            if (deleted) {
                this._shareSubscriptionDAO.unsubscribeAll(personId);
                this._sharePermissionDAO.deletePermissions(personId.asPermissionRole());
            }
            this._personDAO.insertOrUpdate(new PersonCreateModel(personId).setEmail(email).setFirstname(firstname).setFullname(fullname).setImageUrl(imageUrl).setLastname(lastname).setProfileHash(profileHash).setActive(active).setBlocked(blocked).setDeleted(deleted).setTenantId(tenantId));
        });
        this._eventBus.post((Object)new PersonUpdatedEvent(personId));
    }
}

