/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.server.business.impl;

import de.justsoftware.drive.business.server.business.PeopleApiConnector;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
@ParametersAreNonnullByDefault
public class PeopleApiConnectorImpl
implements PeopleApiConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeopleApiConnectorImpl.class);
    private final String _peopleApiUrl;
    private final RestTemplate _restTemplate;

    @Autowired
    public PeopleApiConnectorImpl(@Value(value="${just-people.internal.api.url}") String peopleApiUrl, RestTemplate restTemplate) {
        this._peopleApiUrl = peopleApiUrl;
        this._restTemplate = restTemplate;
    }

    public boolean available() {
        try {
            this._restTemplate.postForLocation(this._peopleApiUrl + "/status", null, new Object[0]);
            return true;
        }
        catch (RestClientException e) {
            LOGGER.error("Failed get the status of the internal people api", (Throwable)e);
            return false;
        }
    }

    public String getPeopleVersion() {
        return (String)this._restTemplate.getForObject(this._peopleApiUrl + "/version", String.class, new Object[0]);
    }

    public UserGroupId getAllUsersGroupForTenant(TenantId tenantId) {
        String url = String.format(this._peopleApiUrl + "/%s/allUsersGroup", tenantId.asPermissionRole().asString());
        return (UserGroupId)this._restTemplate.getForObject(url, UserGroupId.class, new Object[0]);
    }
}

