/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.business.kafka.VirusScanKafkaProducer;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanBo;
import de.justsoftware.drive.persistence.file.VirusScanDAO;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class VirusScannerServiceImpl
implements VirusScannerService {
    private final VirusScanKafkaProducer _producer;
    private final VirusScanDAO _virusScanDAO;

    @Autowired
    public VirusScannerServiceImpl(VirusScanKafkaProducer producer, VirusScanDAO virusScanDAO) {
        this._producer = producer;
        this._virusScanDAO = virusScanDAO;
    }

    public void sendToVirusScan(StorageId storageId, DocumentVersionId documentVersionId) {
        this._virusScanDAO.addVirusScanRequest(storageId);
    }

    public void setVirusScanResult(VirusScanBo virusScanBo) {
        this._virusScanDAO.setVirusScanResult(virusScanBo);
    }

    public void deleteVirusScan(Set<StorageId> storageIds) {
        this._virusScanDAO.deleteVirusScanStatus(storageIds);
    }
}

