/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.virusscan;

import de.justsoftware.justdocumentz.util.CommandExecutionException;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import de.justsoftware.justdocumentz.virusscan.VirusScanException;
import de.justsoftware.justdocumentz.virusscan.VirusScanResult;
import de.justsoftware.justdocumentz.virusscan.VirusScanService;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lde/justsoftware/justdocumentz/virusscan/VirusScanService;", "", "()V", "findVirus", "Lde/justsoftware/justdocumentz/virusscan/VirusScanResult;", "path", "Ljava/nio/file/Path;", "Companion", "just-documentz"})
public class VirusScanService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int EXIT_CODE_OK = 0;
    private static final int EXIT_CODE_VIRUS = 1;

    @NotNull
    public VirusScanResult findVirus(@NotNull Path path) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            objectArray = new String[]{"podman", "exec", "-it", "judo-clamd", "clamdscan", "-i", "--no-summary", "/scandir/" + path.getFileName()};
            List list = CollectionsKt.listOf((Object[])objectArray);
            objectArray = new Integer[]{0, 1};
            objectArray = CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)list, (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, (Collection)SetsKt.setOf((Object[])objectArray), (int)4, null);
        }
        catch (CommandExecutionException e) {
            throw new VirusScanException("Virus scan failed: " + e.getMessage(), (Throwable)e);
        }
        String[] stringArray = objectArray;
        String output = stringArray.component1();
        int exitCode = stringArray.component2();
        return switch (exitCode) {
            case 0 -> new VirusScanResult(false, output);
            case 1 -> new VirusScanResult(true, output);
            default -> throw new IllegalStateException(("Unexpected exit code " + exitCode).toString());
        };
    }
}

