/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.video;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.justdocumentz.common.ContainerImageService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.conversions.ConversionService;
import de.justsoftware.justdocumentz.conversions.video.FfProbeOutput;
import de.justsoftware.justdocumentz.conversions.video.FfProbeVideoStream;
import de.justsoftware.justdocumentz.conversions.video.VideoProbeException;
import de.justsoftware.justdocumentz.monitoring.ConversionAvailabilityTracker;
import de.justsoftware.justdocumentz.util.CommandLineResult;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0016J \u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0012J \u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0012J\u0010\u0010&\u001a\u00020#2\u0006\u0010%\u001a\u00020\u001eH\u0012J\u001b\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b*\u0010+J+\u0010,\u001a\u00020)*\b\u0012\u0004\u0012\u00020\u00160-2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160/\"\u00020\u0016H\u0012\u00a2\u0006\u0002\u00100R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00061"}, d2={"Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;", "Lde/justsoftware/justdocumentz/conversions/ConversionService;", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "containerImageService", "Lde/justsoftware/justdocumentz/common/ContainerImageService;", "environment", "Lorg/springframework/core/env/Environment;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "availabilityTracker", "Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/common/ContainerImageService;Lorg/springframework/core/env/Environment;Lcom/fasterxml/jackson/databind/ObjectMapper;Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;)V", "getAvailabilityTracker", "()Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getContainerImageService", "()Lde/justsoftware/justdocumentz/common/ContainerImageService;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "ffmpegImage", "", "justContainerVersion", "logger", "Lorg/slf4j/Logger;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "convert", "", "Ljava/nio/file/Path;", "inputFile", "tempDir", "convertVideo", "info", "Lde/justsoftware/justdocumentz/conversions/video/FfProbeVideoStream;", "createCoverImage", "videoPath", "getVideoInformation", "onApplicationStartedEvent", "Lkotlin/Result;", "", "onApplicationStartedEvent-d1pmJ48", "()Ljava/lang/Object;", "addArgs", "", "args", "", "(Ljava/util/List;[Ljava/lang/String;)V", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nVideoConversionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoConversionService.kt\nde/justsoftware/justdocumentz/conversions/video/VideoConversionService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n9#2:245\n1#3:246\n288#4,2:247\n*S KotlinDebug\n*F\n+ 1 VideoConversionService.kt\nde/justsoftware/justdocumentz/conversions/video/VideoConversionService\n*L\n31#1:245\n116#1:247,2\n*E\n"})
public class VideoConversionService
implements ConversionService {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final ContainerImageService containerImageService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ConversionAvailabilityTracker availabilityTracker;
    @NotNull
    private final Logger logger;
    @Nullable
    private final String justContainerVersion;
    @NotNull
    private final String ffmpegImage;

    public VideoConversionService(@NotNull JudoConfig config, @NotNull ContainerImageService containerImageService, @NotNull Environment environment, @NotNull ObjectMapper objectMapper, @NotNull ConversionAvailabilityTracker availabilityTracker) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)containerImageService, (String)"containerImageService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)availabilityTracker, (String)"availabilityTracker");
        this.config = config;
        this.containerImageService = containerImageService;
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.availabilityTracker = availabilityTracker;
        VideoConversionService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(VideoConversionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.justContainerVersion = this.getEnvironment().getProperty("just.containerVersion");
        this.ffmpegImage = "docker.io/justsocial/just-ffmpeg-2:" + this.justContainerVersion;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public ContainerImageService getContainerImageService() {
        return this.containerImageService;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public ConversionAvailabilityTracker getAvailabilityTracker() {
        return this.availabilityTracker;
    }

    @EventListener(value={ApplicationStartedEvent.class})
    @NotNull
    public Object onApplicationStartedEvent-d1pmJ48() {
        Object object;
        block5: {
            Object object2;
            object = this;
            try {
                VideoConversionService $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241 = object;
                boolean bl = false;
                String[] stringArray = $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getEnvironment().getActiveProfiles();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
                if (ArraysKt.contains((Object[])stringArray, (Object)"jenkins")) {
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getAvailabilityTracker().setVideoAvailable(true);
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.logger.info("Skipping " + $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getClass().getSimpleName() + " initialization in Jenkins");
                } else {
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.logger.info("Initializing " + $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getClass().getSimpleName() + "...");
                    if (!$this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getContainerImageService().isPodmanAvailable()) {
                        boolean $i$a$-check-VideoConversionService$onApplicationStartedEvent$1$22 = false;
                        String $i$a$-check-VideoConversionService$onApplicationStartedEvent$1$22 = "Podman is not available on this system. Please install Podman to use PDF conversion.";
                        throw new IllegalStateException($i$a$-check-VideoConversionService$onApplicationStartedEvent$1$22.toString());
                    }
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getContainerImageService().ensureImageAvailable($this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.ffmpegImage);
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getAvailabilityTracker().setVideoAvailable(true);
                }
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block5;
            Object e = object2 = throwable;
            boolean bl = false;
            this.getAvailabilityTracker().setVideoAvailable(false);
            this.logger.error("Failed to initialize video conversion", (Throwable)e);
        }
        return object;
    }

    @NotNull
    public List<Path> convert(@NotNull Path inputFile, @NotNull Path tempDir) {
        Object[] objectArray;
        FfProbeVideoStream ffProbeVideoStream;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Object it = ffProbeVideoStream = this.getVideoInformation(inputFile);
        boolean bl = false;
        this.logger.debug("videoInformation: {}", it);
        FfProbeVideoStream videoInformation = ffProbeVideoStream;
        Object it2 = it = this.createCoverImage(inputFile, tempDir, videoInformation);
        boolean bl2 = false;
        this.logger.debug("coverImage: {}", it2);
        Object coverImage = it;
        Object[] it3 = objectArray = this.convertVideo(inputFile, tempDir, videoInformation);
        boolean bl3 = false;
        this.logger.debug("convertedVideo: {}", (Object)it3);
        Object[] convertedVideo = objectArray;
        objectArray = new Path[]{coverImage, convertedVideo};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private FfProbeVideoStream getVideoInformation(Path videoPath) {
        Object $this$getVideoInformation_u24lambda_u2413;
        Object v3;
        block11: {
            Object $this$getVideoInformation_u24lambda_u2410;
            Object $this$getVideoInformation_u24lambda_u248;
            Path inputDir = videoPath.getParent().toAbsolutePath();
            String containerInputDir = "/input";
            VideoConversionService videoConversionService = this;
            try {
                $this$getVideoInformation_u24lambda_u248 = videoConversionService;
                boolean bl = false;
                Object[] objectArray = new String[]{"-v", inputDir + ":" + containerInputDir + ":ro", "--entrypoint", "/usr/local/bin/ffprobe", $this$getVideoInformation_u24lambda_u248.ffmpegImage, "-hide_banner", "-of", "json", "-loglevel", "info", "-show_streams", "-show_format", containerInputDir + "/" + videoPath.getFileName()};
                $this$getVideoInformation_u24lambda_u248 = Result.constructor-impl((Object)CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)$this$getVideoInformation_u24lambda_u248.getConfig().getPodman().getVideo(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)16, null));
            }
            catch (Throwable bl) {
                $this$getVideoInformation_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            videoConversionService = $this$getVideoInformation_u24lambda_u248;
            Throwable throwable = Result.exceptionOrNull-impl((Object)videoConversionService);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                VideoConversionService.getVideoInformation$fail$default((Path)videoPath, (String)"Failed to run ffprobe", (Throwable)it, null, (int)8, null);
                throw new KotlinNothingValueException();
            }
            String output = ((CommandLineResult)videoConversionService).component1();
            VideoConversionService bl = this;
            try {
                $this$getVideoInformation_u24lambda_u2410 = bl;
                boolean bl2 = false;
                $this$getVideoInformation_u24lambda_u2410 = Result.constructor-impl((Object)((FfProbeOutput)$this$getVideoInformation_u24lambda_u2410.getObjectMapper().readValue(output, FfProbeOutput.class)));
            }
            catch (Throwable bl2) {
                $this$getVideoInformation_u24lambda_u2410 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            bl = $this$getVideoInformation_u24lambda_u2410;
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)bl);
            if (throwable2 != null) {
                Throwable it = throwable2;
                boolean bl3 = false;
                VideoConversionService.getVideoInformation$fail((Path)videoPath, (String)"Failed to parse ffprobe output", (Throwable)it, (String)output);
                throw new KotlinNothingValueException();
            }
            FfProbeOutput ffProbeOutput = (FfProbeOutput)bl;
            Iterable $this$firstOrNull$iv = ffProbeOutput.getStreams();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JsonNode it = (JsonNode)element$iv;
                boolean bl4 = false;
                JsonNode jsonNode = it.get("codec_type");
                if (!Intrinsics.areEqual((Object)(jsonNode != null ? jsonNode.asText() : null), (Object)"video")) continue;
                v3 = element$iv;
                break block11;
            }
            v3 = null;
        }
        JsonNode jsonNode = v3;
        if (jsonNode == null) {
            VideoConversionService.getVideoInformation$fail$default((Path)videoPath, (String)"No video stream found", null, null, (int)12, null);
            throw new KotlinNothingValueException();
        }
        JsonNode videoStreamNode = jsonNode;
        VideoConversionService videoConversionService = this;
        try {
            $this$getVideoInformation_u24lambda_u2413 = videoConversionService;
            boolean bl = false;
            $this$getVideoInformation_u24lambda_u2413 = Result.constructor-impl((Object)((FfProbeVideoStream)$this$getVideoInformation_u24lambda_u2413.getObjectMapper().treeToValue((TreeNode)videoStreamNode, FfProbeVideoStream.class)));
        }
        catch (Throwable bl) {
            $this$getVideoInformation_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        videoConversionService = $this$getVideoInformation_u24lambda_u2413;
        Throwable throwable = Result.exceptionOrNull-impl((Object)videoConversionService);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            VideoConversionService.getVideoInformation$fail$default((Path)videoPath, (String)"Failed to parse video stream", (Throwable)it, null, (int)8, null);
            throw new KotlinNothingValueException();
        }
        VideoConversionService videoConversionService2 = videoConversionService;
        Intrinsics.checkNotNullExpressionValue((Object)videoConversionService2, (String)"getOrElse(...)");
        return (FfProbeVideoStream)videoConversionService2;
    }

    private Path createCoverImage(Path videoPath, Path tempDir, FfProbeVideoStream info) {
        Path inputDir = videoPath.getParent();
        String containerInputDir = "/input";
        String containerOutputDir = "/output";
        String outputFileName = "cover-image.png";
        Object[] objectArray = new String[]{"-v", inputDir + ":" + containerInputDir + ":ro", "-v", tempDir + ":" + containerOutputDir, this.ffmpegImage, "-y", "-ss", String.valueOf(MathKt.roundToInt((double)(info.getDuration() / (double)2))), "-i", containerInputDir + "/" + videoPath.getFileName(), "-frames:v", "1", containerOutputDir + "/" + outputFileName};
        CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)this.getConfig().getPodman().getVideo(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)24, null);
        Path coverImagePath = tempDir.resolve(outputFileName);
        if (!Files.exists(coverImagePath, new LinkOption[0])) {
            boolean bl = false;
            String string = "Cover image generation appeared to succeed but output file not found: " + coverImagePath;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)coverImagePath);
        return coverImagePath;
    }

    private Path convertVideo(Path inputFile, Path tempDir, FfProbeVideoStream info) {
        List list;
        String targetPixelFormat = "yuv420p";
        String targetVideoCodec = "h264";
        Path inputDir = inputFile.getParent();
        String containerInputDir = "/input";
        String containerOutputDir = "/output";
        String outputFileName = "output.mp4";
        boolean isTooLarge = info.getWidth() > info.getHeight() ? info.getHeight() > 720 : info.getWidth() > 1280;
        boolean dimensionsDivisibleByTwo = info.getWidth() % 2 == 0 && info.getHeight() % 2 == 0;
        boolean needsScaling = isTooLarge || !dimensionsDivisibleByTwo;
        boolean needsReEncoding = !Intrinsics.areEqual((Object)info.getCodecName(), (Object)targetVideoCodec) || !Intrinsics.areEqual((Object)info.getPixelFormat(), (Object)targetPixelFormat) || needsScaling;
        String videoCodec = needsReEncoding ? "libx264" : "copy";
        List $this$convertVideo_u24lambda_u2416 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"-v", inputDir + ":" + containerInputDir + ":ro"};
        this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        stringArray = new String[]{"-v", tempDir + ":" + containerOutputDir};
        this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        $this$convertVideo_u24lambda_u2416.add(this.ffmpegImage);
        stringArray = new String[]{"-i", containerInputDir + "/" + inputFile.getFileName()};
        this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        if (needsReEncoding) {
            stringArray = new String[]{"-preset", "fast"};
            this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
            stringArray = new String[]{"-crf", "23"};
            this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
            stringArray = new String[]{"-pix_fmt", targetPixelFormat};
            this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        }
        if (needsScaling) {
            stringArray = new String[]{"-vf", info.getWidth() > info.getHeight() ? "scale=-2:720" : "scale=1280:-2"};
            this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        }
        stringArray = new String[]{"-c:v", videoCodec};
        this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        stringArray = new String[]{"-c:a", "aac"};
        this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        stringArray = new String[]{"-b:a", "128k"};
        this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        stringArray = new String[]{"-movflags", "+faststart"};
        this.addArgs($this$convertVideo_u24lambda_u2416, stringArray);
        $this$convertVideo_u24lambda_u2416.add(containerOutputDir + "/" + outputFileName);
        List command = CollectionsKt.build((List)list);
        CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)command, (PodmanConfig)this.getConfig().getPodman().getVideo(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)24, null);
        Path convertedVideoPath = tempDir.resolve(outputFileName);
        if (!Files.exists(convertedVideoPath, new LinkOption[0])) {
            boolean bl2 = false;
            String string = "Video conversion appeared to succeed but output file not found: " + convertedVideoPath;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)convertedVideoPath);
        return convertedVideoPath;
    }

    private void addArgs(List<String> $this$addArgs, String ... args) {
        CollectionsKt.addAll((Collection)$this$addArgs, (Object[])args);
    }

    private static final Void getVideoInformation$fail(Path $videoPath, String message, Throwable cause, String output) {
        StringBuilder stringBuilder;
        StringBuilder $this$getVideoInformation_u24fail_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getVideoInformation_u24fail_u24lambda_u247.append(message + " for: " + $videoPath);
        String string = output;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$getVideoInformation_u24fail_u24lambda_u247.append("\nOutput was: \n" + output);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Throwable throwable = cause;
        String string3 = string2;
        throw new VideoProbeException(string3, throwable);
    }

    static /* synthetic */ Void getVideoInformation$fail$default(Path path, String string, Throwable throwable, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getVideoInformation$fail");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return VideoConversionService.getVideoInformation$fail((Path)path, (String)string, (Throwable)throwable, (String)string2);
    }
}

