/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.persistence.model.DbChatMessageReaction;
import de.justsoftware.chat.persistence.model.DbProfileIdProjection;
import de.justsoftware.chat.persistence.model.DbReactionId;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H'J(\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H'J\u0016\u0010\r\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H'J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0013\u001a\u00020\bH&J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u0017\u001a\u00020\u0018H'J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageReactionRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbChatMessageReaction;", "Lde/justsoftware/chat/persistence/model/DbReactionId;", "findAllByMessageIdIn", "", "messageIds", "", "Ljava/util/UUID;", "findByMessageIds", "", "deleteAllByMessageIdIn", "", "deleteByMessageIds", "deleteByChatIdIn", "chatIds", "deleteByChatIds", "findProfileIdsByMessageId", "Lde/justsoftware/chat/persistence/model/DbProfileIdProjection;", "messageId", "findByUpdatedAtGreaterThanAndParticipantIdsIn", "participantIds", "", "updatedAt", "Ljava/time/Instant;", "findByUpdatedAtGreaterThanAndParticipantIds", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageReactionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageReactionRepository.kt\nde/justsoftware/chat/persistence/ChatMessageReactionRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,99:1\n1374#2:100\n1460#2,5:101\n1491#2:106\n1516#2,3:107\n1519#2,3:117\n1869#2,2:120\n1869#2,2:122\n1374#2:124\n1460#2,5:125\n382#3,7:110\n*S KotlinDebug\n*F\n+ 1 ChatMessageReactionRepository.kt\nde/justsoftware/chat/persistence/ChatMessageReactionRepository\n*L\n26#1:100\n26#1:101,5\n27#1:106\n27#1:107,3\n27#1:117,3\n39#1:120,2\n63#1:122,2\n97#1:124\n97#1:125,5\n27#1:110,7\n*E\n"})
public interface ChatMessageReactionRepository
extends JpaRepository<DbChatMessageReaction, DbReactionId> {
    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findByMessageIds(messageIds)", imports={}))
    @NotNull
    public List<DbChatMessageReaction> findAllByMessageIdIn(@NotNull Iterable<UUID> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<UUID, List<DbChatMessageReaction>> findByMessageIds(@NotNull Iterable<UUID> messageIds) {
        void $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(messageIds, (String)"messageIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(messageIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.findAllByMessageIdIn((Iterable)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            DbChatMessageReaction p0 = (DbChatMessageReaction)element$iv$iv;
            boolean bl = false;
            UUID key$iv$iv = p0.getMessageId();
            Object object2 = destination$iv$iv;
            UUID key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="deleteByMessageIds(messageIds)", imports={}))
    public void deleteAllByMessageIdIn(@NotNull Iterable<UUID> var1);

    default public void deleteByMessageIds(@NotNull Iterable<UUID> messageIds) {
        Intrinsics.checkNotNullParameter(messageIds, (String)"messageIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked(messageIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.deleteAllByMessageIdIn((Iterable)it);
        }
    }

    @Query(value="\n            DELETE\n            FROM DbChatMessageReaction r\n            WHERE r.messageId IN (\n                SELECT id\n                FROM DbChatMessage cm\n                WHERE cm.chatId IN :chatIds\n            )\n        ")
    @Modifying
    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="deleteByMessageIds(chatIds)", imports={}))
    public void deleteByChatIdIn(@NotNull Iterable<UUID> var1);

    default public void deleteByChatIds(@NotNull Iterable<UUID> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked(chatIds, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.deleteByChatIdIn((Iterable)it);
        }
    }

    @NotNull
    public List<DbProfileIdProjection> findProfileIdsByMessageId(@NotNull UUID var1);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findByUpdatedAtGreaterThanAndParticipantIds(participantIds, updatedAt)", imports={}))
    @Query(value="\n        SELECT r\n        FROM DbChatMessageReaction r\n        WHERE r.updatedAt > :updatedAt\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatMessage m\n            JOIN DbChatParticipant cp ON cp.chatId = m.chatId\n            WHERE m.id = r.messageId\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<DbChatMessageReaction> findByUpdatedAtGreaterThanAndParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<DbChatMessageReaction> findByUpdatedAtGreaterThanAndParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant updatedAt) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findByUpdatedAtGreaterThanAndParticipantIdsIn((Iterable)it, updatedAt);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

