/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.RemovedEntitiesForSyncCleanupService;
import de.justsoftware.chat.mobile.service.MobileApplicationService;
import de.justsoftware.chat.persistence.RemovedMessageReactionForSyncRepository;
import de.justsoftware.chat.persistence.RemovedParticipantProfileForSyncRepository;
import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/chat/business/RemovedEntitiesForSyncCleanupService;", "", "removedParticipantProfileRepository", "Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;", "removedMessageReactionForSyncRepository", "Lde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;Lde/justsoftware/chat/persistence/RemovedMessageReactionForSyncRepository;Ljava/time/Clock;)V", "cleanObsoleteEntries", "", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nRemovedEntitiesForSyncCleanupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemovedEntitiesForSyncCleanupService.kt\nde/justsoftware/chat/business/RemovedEntitiesForSyncCleanupService\n+ 2 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,39:1\n9#2:40\n8#2,3:41\n*S KotlinDebug\n*F\n+ 1 RemovedEntitiesForSyncCleanupService.kt\nde/justsoftware/chat/business/RemovedEntitiesForSyncCleanupService\n*L\n36#1:40\n36#1:41,3\n*E\n"})
public class RemovedEntitiesForSyncCleanupService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final RemovedParticipantProfileForSyncRepository removedParticipantProfileRepository;
    @NotNull
    private final RemovedMessageReactionForSyncRepository removedMessageReactionForSyncRepository;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Logger LOG;

    public RemovedEntitiesForSyncCleanupService(@NotNull RemovedParticipantProfileForSyncRepository removedParticipantProfileRepository, @NotNull RemovedMessageReactionForSyncRepository removedMessageReactionForSyncRepository, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)removedParticipantProfileRepository, (String)"removedParticipantProfileRepository");
        Intrinsics.checkNotNullParameter((Object)removedMessageReactionForSyncRepository, (String)"removedMessageReactionForSyncRepository");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.removedParticipantProfileRepository = removedParticipantProfileRepository;
        this.removedMessageReactionForSyncRepository = removedMessageReactionForSyncRepository;
        this.clock = clock;
    }

    @Scheduled(cron="0 10 20 * * *")
    @Transactional
    public void cleanObsoleteEntries() {
        Instant deleteBeforeDate = this.clock.instant().minus(MobileApplicationService.Companion.getCHAT_CHANGES_MAX_AGE());
        LOG.info("Start deleting removed participant profile and message reaction entries from before " + deleteBeforeDate);
        Intrinsics.checkNotNull((Object)deleteBeforeDate);
        int deletedRemovedParticipants = this.removedParticipantProfileRepository.deleteByCreatedAtLessThan(deleteBeforeDate);
        int deletedRemovedReactions = this.removedMessageReactionForSyncRepository.deleteByUpdatedAtLessThan(deleteBeforeDate);
        LOG.info("Deleted " + deletedRemovedParticipants + " removed participant profile and " + deletedRemovedReactions + " removed message reaction entries");
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

