/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.DriveService;
import de.justsoftware.chat.business.DriveService$uploadTempFiles$;
import de.justsoftware.chat.business.model.drive.DriveAttachment;
import de.justsoftware.chat.business.model.drive.DriveTempFile;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.PersistFilesException;
import de.justsoftware.chat.model.DriveDocumentId;
import de.justsoftware.chat.model.ImageSize;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.RestClientUtilsKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 +2\u00020\u0001:\u0001+B9\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJK\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0010\u0012\u0004\u0012\u0002H\u000e0\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00102\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J$\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J&\u0010)\u001a\u00020\u001a2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020(0\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lde/justsoftware/chat/business/DriveService;", "", "driveApiUrl", "", "driveInternalApiUrl", "apiGatewayRestClient", "Lorg/springframework/web/client/RestClient;", "internalApiRestClient", "driveFileUploadRestClient", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/web/client/RestClient;Lorg/springframework/web/client/RestClient;Lorg/springframework/web/client/RestClient;)V", "persistTemporaryFilesUrl", "uploadTemporaryFilesUrl", "uploadFiles", "T", "files", "", "Lorg/springframework/web/multipart/MultipartFile;", "targetItemId", "creator", "Lde/justsoftware/chat/model/ProfileId;", "callback", "Lkotlin/Function1;", "Lde/justsoftware/chat/business/model/drive/DriveAttachment;", "(Ljava/util/List;Ljava/lang/String;Lde/justsoftware/chat/model/ProfileId;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "deleteFiles", "", "ids", "Lde/justsoftware/chat/model/DriveDocumentId;", "deleter", "downloadFileUrl", "id", "downloadFileThumbnailUri", "Ljava/net/URI;", "size", "Lde/justsoftware/chat/model/ImageSize;", "downloadFilePreviewUrl", "getVideoStreamUrl", "getUnauthorizedVideoUrl", "uploadTempFiles", "Lde/justsoftware/chat/business/model/drive/DriveTempFile;", "persistFiles", "filesToPersist", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nDriveService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveService.kt\nde/justsoftware/chat/business/DriveService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RestClientUtils.kt\nde/justsoftware/chat/util/RestClientUtilsKt\n+ 4 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n*L\n1#1,139:1\n1563#2:140\n1634#2,3:141\n1563#2:144\n1634#2,3:145\n1869#2,2:148\n1634#2,3:156\n18#3:150\n18#3:153\n43#4:151\n43#4:154\n1#5:152\n7#6:155\n*S KotlinDebug\n*F\n+ 1 DriveService.kt\nde/justsoftware/chat/business/DriveService\n*L\n42#1:140\n42#1:141,3\n51#1:144\n51#1:145,3\n52#1:148,2\n103#1:156,3\n82#1:150\n95#1:153\n82#1:151\n95#1:154\n103#1:155\n*E\n"})
public class DriveService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String driveApiUrl;
    @NotNull
    private final String driveInternalApiUrl;
    @NotNull
    private final RestClient apiGatewayRestClient;
    @NotNull
    private final RestClient internalApiRestClient;
    @NotNull
    private final RestClient driveFileUploadRestClient;
    @NotNull
    private final String persistTemporaryFilesUrl;
    @NotNull
    private final String uploadTemporaryFilesUrl;

    public DriveService(@Value(value="${just.drive.api.url}") @NotNull String driveApiUrl, @Value(value="${just.drive.internal}") @NotNull String driveInternalApiUrl, @Qualifier(value="apiGatewayRestClient") @NotNull RestClient apiGatewayRestClient, @Qualifier(value="internalApiRestClient") @NotNull RestClient internalApiRestClient, @Qualifier(value="driveFileUploadRestClient") @NotNull RestClient driveFileUploadRestClient) {
        Intrinsics.checkNotNullParameter((Object)driveApiUrl, (String)"driveApiUrl");
        Intrinsics.checkNotNullParameter((Object)driveInternalApiUrl, (String)"driveInternalApiUrl");
        Intrinsics.checkNotNullParameter((Object)apiGatewayRestClient, (String)"apiGatewayRestClient");
        Intrinsics.checkNotNullParameter((Object)internalApiRestClient, (String)"internalApiRestClient");
        Intrinsics.checkNotNullParameter((Object)driveFileUploadRestClient, (String)"driveFileUploadRestClient");
        this.driveApiUrl = driveApiUrl;
        this.driveInternalApiUrl = driveInternalApiUrl;
        this.apiGatewayRestClient = apiGatewayRestClient;
        this.internalApiRestClient = internalApiRestClient;
        this.driveFileUploadRestClient = driveFileUploadRestClient;
        this.persistTemporaryFilesUrl = this.driveInternalApiUrl + "/tmp/move";
        this.uploadTemporaryFilesUrl = this.driveInternalApiUrl + "/tmp/upload";
    }

    /*
     * WARNING - void declaration
     */
    public <T> T uploadFiles(@NotNull List<? extends MultipartFile> files, @NotNull String targetItemId, @NotNull ProfileId creator, @NotNull Function1<? super List<DriveAttachment>, ? extends T> callback) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)targetItemId, (String)"targetItemId");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        List tempFiles = this.uploadTempFiles(files, creator);
        Object object = CollectionsKt.zip((Iterable)tempFiles, (Iterable)files);
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DriveTempFile tempFile = (DriveTempFile)pair.component1();
            MultipartFile file = (MultipartFile)pair.component2();
            collection.add(Companion.access$toDriveAttachment((Companion)Companion, (DriveTempFile)tempFile, (MultipartFile)file));
        }
        object = (List)destination$iv$iv;
        Object it = object = callback.invoke(object);
        boolean bl = false;
        this.persistFiles(tempFiles, targetItemId, creator);
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteFiles(@NotNull List<DriveDocumentId> ids, @NotNull ProfileId deleter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)deleter, (String)"deleter");
        Iterable $this$map$iv = ids;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            DriveDocumentId driveDocumentId = (DriveDocumentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.driveInternalApiUrl + "/file/" + file.getValue() + "/delete?deletingUser=" + deleter.getValue());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String url = (String)element$iv;
            boolean bl = false;
            this.internalApiRestClient.delete().uri(url, new Object[0]).retrieve().toBodilessEntity();
        }
    }

    @NotNull
    public String downloadFileUrl(@NotNull DriveDocumentId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.driveApiUrl + "/documents/" + id.getValue() + "/download";
    }

    @NotNull
    public URI downloadFileThumbnailUri(@NotNull DriveDocumentId id, @NotNull ImageSize size) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"width", (Object)size.getWidth()), TuplesKt.to((Object)"height", (Object)size.getHeight())};
        return RestClientUtilsKt.buildUri$default((String)(this.driveApiUrl + "/previews/thumbnail/" + id.getValue()), (Map)MapsKt.mapOf((Pair[])pairArray), null, (int)4, null);
    }

    @NotNull
    public String downloadFilePreviewUrl(@NotNull DriveDocumentId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.driveApiUrl + "/previews/previewImage/" + id.getValue() + "/latest";
    }

    @NotNull
    public String getVideoStreamUrl(@NotNull DriveDocumentId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.driveApiUrl + "/previews/embed/" + id.getValue() + "/latest";
    }

    @NotNull
    public String getUnauthorizedVideoUrl(@NotNull DriveDocumentId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RestClient.ResponseSpec responseSpec = this.apiGatewayRestClient.get().uri(this.driveApiUrl + "/previews/preview/" + id.getValue() + "/accessToken", new Object[0]).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$bodyOrNotFound$iv = responseSpec;
        boolean $i$f$bodyOrNotFound = false;
        RestClient.ResponseSpec $this$body$iv$iv = $this$bodyOrNotFound$iv;
        boolean $i$f$body = false;
        Object object = $this$body$iv$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (object == null) {
            throw new NotFoundException("Empty response body");
        }
        char[] cArray = new char[]{'\"'};
        String accessToken = StringsKt.trim((String)((String)object), (char[])cArray);
        boolean bl = false;
        return "/drive/api/unauthenticated/previewVideoFile/" + accessToken;
    }

    /*
     * WARNING - void declaration
     */
    private List<DriveTempFile> uploadTempFiles(List<? extends MultipartFile> files, ProfileId creator) {
        void $this$bodyOrNotFound$iv;
        MultiValueMap postData = RestClientUtilsKt.createMultipartFilesPayload((String)"files", files);
        postData.add((Object)"ownerId", (Object)creator.getValue());
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)this.driveFileUploadRestClient.post().uri(this.uploadTemporaryFilesUrl, new Object[0])).body((Object)postData).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec responseSpec2 = responseSpec;
        boolean $i$f$bodyOrNotFound = false;
        void $this$body$iv$iv = $this$bodyOrNotFound$iv;
        boolean $i$f$body = false;
        Object object = $this$body$iv$iv.body((ParameterizedTypeReference)new uploadTempFiles$$inlined$bodyOrNotFound$1());
        if (object == null) {
            throw new NotFoundException("Empty response body");
        }
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private void persistFiles(List<DriveTempFile> filesToPersist, String targetItemId, ProfileId creator) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv = filesToPersist;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DriveTempFile driveTempFile = (DriveTempFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Set idsToPersists = (Set)destination$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"targetItemId", (Object)targetItemId), TuplesKt.to((Object)"tempFileIds", (Object)idsToPersists), TuplesKt.to((Object)"ownerId", (Object)creator.getValue())};
        ((RestClient.RequestBodySpec)this.internalApiRestClient.post().uri(this.persistTemporaryFilesUrl, new Object[0])).body((Object)MapsKt.mapOf((Pair[])pairArray)).retrieve().onStatus(DriveService::persistFiles$lambda$0, (arg_0, arg_1) -> DriveService.persistFiles$lambda$1(idsToPersists, arg_0, arg_1)).toBodilessEntity();
    }

    private static final boolean persistFiles$lambda$0(HttpStatusCode it) {
        return !it.is2xxSuccessful();
    }

    private static final void persistFiles$lambda$1(Set $idsToPersists, HttpRequest httpRequest, ClientHttpResponse response) {
        HttpStatusCode httpStatusCode = response.getStatusCode();
        Intrinsics.checkNotNullExpressionValue((Object)httpStatusCode, (String)"getStatusCode(...)");
        throw new PersistFilesException($idsToPersists, httpStatusCode);
    }
}

