/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.event.ChatSettingsChangedEvent;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.persistence.ChatSettingsRepository;
import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbChatSettings;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0016J*\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0016J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0012J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/justsoftware/chat/business/ChatSettingsService;", "", "chatSettingsRepository", "Lde/justsoftware/chat/persistence/ChatSettingsRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "<init>", "(Lde/justsoftware/chat/persistence/ChatSettingsRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/util/TransactionUtils;)V", "getSettings", "", "Lde/justsoftware/chat/model/ChatId;", "Lde/justsoftware/chat/business/model/ChatSettings;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "chatIds", "", "getSettingsForChat", "chatId", "profileIds", "muteChat", "isMuted", "", "findByProfileIdsAndChatIds", "", "findUpdatedAndSpecificSettings", "updatedSince", "Ljava/time/Instant;", "save", "chatSettings", "findByChatIdAndProfileId", "Ljava/util/Optional;", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatSettingsService.kt\nde/justsoftware/chat/business/ChatSettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n*L\n1#1,105:1\n1563#2:106\n1634#2,3:107\n1193#2,2:110\n1267#2,4:112\n1563#2:116\n1634#2,3:117\n1193#2,2:120\n1267#2,4:122\n1563#2:126\n1634#2,3:127\n1634#2,3:131\n1563#2:134\n1634#2,3:135\n1563#2:138\n1634#2,3:139\n1563#2:142\n1634#2,3:143\n7#3:130\n*S KotlinDebug\n*F\n+ 1 ChatSettingsService.kt\nde/justsoftware/chat/business/ChatSettingsService\n*L\n28#1:106\n28#1:107,3\n30#1:110,2\n30#1:112,4\n34#1:116\n34#1:117,3\n36#1:120,2\n36#1:122,4\n60#1:126\n60#1:127,3\n61#1:131,3\n63#1:134\n63#1:135,3\n77#1:138\n77#1:139,3\n78#1:142\n78#1:143,3\n61#1:130\n*E\n"})
public class ChatSettingsService {
    @NotNull
    private final ChatSettingsRepository chatSettingsRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final TransactionUtils transactionUtils;

    public ChatSettingsService(@NotNull ChatSettingsRepository chatSettingsRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull TransactionUtils transactionUtils) {
        Intrinsics.checkNotNullParameter((Object)chatSettingsRepository, (String)"chatSettingsRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        this.chatSettingsRepository = chatSettingsRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.transactionUtils = transactionUtils;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, ChatSettings> getSettings(@NotNull ProfileId profileId, @NotNull Set<ChatId> chatIds) {
        void $this$associateTo$iv$iv;
        Collection<UUID> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable iterable = chatIds;
        String string = profileId.toCanonicalId();
        ChatSettingsRepository chatSettingsRepository = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        Iterable $this$associate$iv = chatSettingsRepository.findByProfileIdAndChatIds(string, (Iterable)collection).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID chatId = (UUID)entry.getKey();
            DbChatSettings dbChatSettings = (DbChatSettings)entry.getValue();
            entry = TuplesKt.to((Object)new ChatId(chatId), (Object)DbChatSettings.Companion.toChatSettings(dbChatSettings));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, ChatSettings> getSettingsForChat(@NotNull ChatId chatId, @NotNull Set<ProfileId> profileIds) {
        void $this$associateTo$iv$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        UUID uUID = chatId.getValue();
        ChatSettingsRepository chatSettingsRepository = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv;
        Iterable $this$associate$iv = chatSettingsRepository.findByChatIdAndProfileIds(uUID, (Iterable)collection).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String profileId = (String)entry.getKey();
            DbChatSettings dbChatSettings = (DbChatSettings)entry.getValue();
            entry = TuplesKt.to((Object)ProfileId.Companion.fromCanonicalId(profileId), (Object)DbChatSettings.Companion.toChatSettings(dbChatSettings));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @Transactional
    @NotNull
    public ChatSettings muteChat(@NotNull ChatId chatId, @NotNull ProfileId profileId, boolean isMuted) {
        ChatSettings chatSettings2;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ChatSettings currentSettings = this.findByChatIdAndProfileId(chatId, profileId).orElseGet(() -> ChatSettingsService.muteChat$lambda$0(chatId, profileId));
        if (currentSettings.getMuted() == isMuted) {
            Intrinsics.checkNotNull((Object)currentSettings);
            chatSettings2 = currentSettings;
        } else {
            Intrinsics.checkNotNull((Object)currentSettings);
            chatSettings2 = this.save(ChatSettings.copy$default((ChatSettings)currentSettings, null, null, (boolean)isMuted, null, (int)11, null));
        }
        return chatSettings2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChatSettings> findByProfileIdsAndChatIds(@NotNull Set<ProfileId> profileIds, @NotNull Set<ChatId> chatIds) {
        Collection<UUID> collection;
        void $this$mapToSet$iv;
        ChatId p0;
        Iterable<String> iterable;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable iterable2 = profileIds;
        Object object = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProfileId profileId = (ProfileId)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(p0.toCanonicalId());
        }
        $this$map$iv = chatIds;
        iterable = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (Set)destination$iv$iv;
        $this$map$iv = object.findByProfileIdsAndChatIds(iterable, (Iterable)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbChatSettings)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(DbChatSettings.Companion.toChatSettings((DbChatSettings)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChatSettings> findUpdatedAndSpecificSettings(@NotNull ProfileId profileId, @NotNull Set<ChatId> chatIds, @NotNull Instant updatedSince) {
        DbChatSettings p0;
        Collection<UUID> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)updatedSince, (String)"updatedSince");
        if (!(chatIds.size() <= 1000)) {
            boolean $i$a$-require-ChatSettingsService$findUpdatedAndSpecificSettings$22 = false;
            String $i$a$-require-ChatSettingsService$findUpdatedAndSpecificSettings$22 = "Got " + chatIds.size() + " chat IDs, but only 1000 are allowed in a WHERE-IN-clause";
            throw new IllegalArgumentException($i$a$-require-ChatSettingsService$findUpdatedAndSpecificSettings$22.toString());
        }
        Iterable iterable = chatIds;
        Instant instant = updatedSince;
        String string = profileId.toCanonicalId();
        Object object = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var6_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = object.findByProfileIdAndUpdatedAtGreaterThanOrChatIdIn(string, instant, (Iterable)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbChatSettings)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(DbChatSettings.Companion.toChatSettings((DbChatSettings)it));
        }
        return (List)destination$iv$iv;
    }

    private ChatSettings save(ChatSettings chatSettings2) {
        ChatSettings chatSettings3;
        Object object = this.chatSettingsRepository.save((Object)DbChatSettings.Companion.toDbChatSettings(chatSettings2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        ChatSettings savedChatSettings = chatSettings3 = DbChatSettings.Companion.toChatSettings((DbChatSettings)object);
        boolean bl = false;
        this.transactionUtils.afterCommit(() -> ChatSettingsService.save$lambda$0$0(this, savedChatSettings));
        return chatSettings3;
    }

    private Optional<ChatSettings> findByChatIdAndProfileId(ChatId chatId, ProfileId profileId) {
        Optional<ChatSettings> optional = this.chatSettingsRepository.findById((Object)new DbChatProfileId(chatId, profileId)).map(arg_0 -> ChatSettingsService.findByChatIdAndProfileId$lambda$1(ChatSettingsService::findByChatIdAndProfileId$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    private static final ChatSettings muteChat$lambda$0(ChatId $chatId, ProfileId $profileId) {
        return new ChatSettings($chatId, $profileId, false, null, 12, null);
    }

    private static final Unit save$lambda$0$0(ChatSettingsService this$0, ChatSettings $savedChatSettings) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatSettingsChangedEvent((Object)this$0, $savedChatSettings.getChatId(), $savedChatSettings.getProfileId()));
        return Unit.INSTANCE;
    }

    private static final ChatSettings findByChatIdAndProfileId$lambda$0(DbChatSettings it) {
        Intrinsics.checkNotNull((Object)it);
        return DbChatSettings.Companion.toChatSettings(it);
    }

    private static final ChatSettings findByChatIdAndProfileId$lambda$1(Function1 $tmp0, Object p0) {
        return (ChatSettings)$tmp0.invoke(p0);
    }
}

