/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.token;

import de.justsoftware.authorization.config.JustAuthorizationContext;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.token.JWTService;
import de.justsoftware.authorization.token.JwtConfigurationException;
import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jose4j.lang.JoseException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseCookie;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0012J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/authorization/token/JWTService;", "", "jwtLifetime", "Ljava/time/Duration;", "jwtGenerator", "Lde/justsoftware/jwtfilter/generator/JwtGenerator;", "<init>", "(Ljava/time/Duration;Lde/justsoftware/jwtfilter/generator/JwtGenerator;)V", "createJwt", "", "authContext", "Lde/justsoftware/authorization/config/JustAuthorizationContext;", "addJwtCookie", "", "rememberMeAuthenticationToken", "Lorg/springframework/security/authentication/AbstractAuthenticationToken;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "createLoginJWT", "personId", "Lde/justsoftware/authorization/id/ProfileId;", "tenantId", "Lde/justsoftware/authorization/id/TenantId;", "lifetime", "addCookie", "jwtToken", "Companion", "just-authorization-server"})
public class JWTService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration jwtLifetime;
    @NotNull
    private final JwtGenerator jwtGenerator;
    @NotNull
    private static final String JUST_ID_COOKIE_NAME = "just-id";

    public JWTService(@Value(value="${just.auth.jwtLifetime}") @NotNull Duration jwtLifetime, @NotNull JwtGenerator jwtGenerator) {
        Intrinsics.checkNotNullParameter((Object)jwtLifetime, (String)"jwtLifetime");
        Intrinsics.checkNotNullParameter((Object)jwtGenerator, (String)"jwtGenerator");
        this.jwtLifetime = jwtLifetime;
        this.jwtGenerator = jwtGenerator;
    }

    @Nullable
    public String createJwt(@NotNull JustAuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.createLoginJWT(authContext.getProfileId(), authContext.getTenantId(), this.jwtLifetime);
    }

    public void addJwtCookie(@NotNull AbstractAuthenticationToken rememberMeAuthenticationToken, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)rememberMeAuthenticationToken, (String)"rememberMeAuthenticationToken");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (rememberMeAuthenticationToken.getPrincipal() instanceof JustUser) {
            Object object = rememberMeAuthenticationToken.getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.justsoftware.authorization.oauth2.JustUser");
            JustUser user = (JustUser)object;
            if (user.getTenantId() != null) {
                String jwt = this.createLoginJWT(user.getProfileId(), user.getTenantId(), this.jwtLifetime);
                this.addCookie(jwt, response);
            }
        }
    }

    private String createLoginJWT(ProfileId personId, TenantId tenantId, Duration lifetime) {
        JwtClaimsBuilder jwtClaimsBuilder = new JwtClaimsBuilder().withLifetime(lifetime.toMinutes()).withSubject(String.valueOf(personId.getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)jwtClaimsBuilder, (String)"withSubject(...)");
        JwtClaimsBuilder claimsBuilder = jwtClaimsBuilder;
        if (tenantId != null) {
            claimsBuilder.withCustomClaim(TenantId.Companion.getJsonKey(), tenantId.toString());
        }
        try {
            String string = this.jwtGenerator.generateJWT(claimsBuilder);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateJWT(...)");
            return string;
        }
        catch (JoseException e) {
            throw new JwtConfigurationException((Exception)((Object)e));
        }
        catch (JwtKeyLoadingException e) {
            throw new JwtConfigurationException((Exception)((Object)e));
        }
    }

    private void addCookie(String jwtToken, HttpServletResponse response) {
        ResponseCookie responseCookie = ResponseCookie.from((String)JUST_ID_COOKIE_NAME, (String)jwtToken).maxAge(-1L).secure(true).httpOnly(true).path("/").build();
        Intrinsics.checkNotNullExpressionValue((Object)responseCookie, (String)"build(...)");
        ResponseCookie cookie = responseCookie;
        response.addHeader("Set-Cookie", cookie.toString());
    }
}

