/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller;

import de.justsoftware.authorization.controller.LoginController;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelExtensionsKt;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lde/justsoftware/authorization/controller/LoginController;", "", "env", "Lorg/springframework/core/env/Environment;", "systemDomainPrefix", "", "<init>", "(Lorg/springframework/core/env/Environment;Ljava/lang/String;)V", "getEnv", "()Lorg/springframework/core/env/Environment;", "getSystemDomainPrefix", "()Ljava/lang/String;", "defaultRedirectStrategy", "Lorg/springframework/security/web/DefaultRedirectStrategy;", "getDefaultRedirectStrategy", "()Lorg/springframework/security/web/DefaultRedirectStrategy;", "login", "model", "Lorg/springframework/ui/Model;", "csrfToken", "Lorg/springframework/security/web/csrf/CsrfToken;", "session", "Ljakarta/servlet/http/HttpSession;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "isAuthenticatedUser", "", "auth", "Lorg/springframework/security/core/Authentication;", "Companion", "just-authorization-server"})
public class LoginController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Environment env;
    @NotNull
    private final String systemDomainPrefix;
    @NotNull
    private final DefaultRedirectStrategy defaultRedirectStrategy;
    @NotNull
    public static final String LOGIN_PAGE = "/login";

    public LoginController(@NotNull Environment env, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        this.env = env;
        this.systemDomainPrefix = systemDomainPrefix;
        this.defaultRedirectStrategy = new DefaultRedirectStrategy();
    }

    @NotNull
    public Environment getEnv() {
        return this.env;
    }

    @NotNull
    public String getSystemDomainPrefix() {
        return this.systemDomainPrefix;
    }

    @NotNull
    public DefaultRedirectStrategy getDefaultRedirectStrategy() {
        return this.defaultRedirectStrategy;
    }

    @GetMapping(value={"/login"})
    @NotNull
    public String login(@NotNull Model model, @NotNull CsrfToken csrfToken, @NotNull HttpSession session, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)csrfToken, (String)"csrfToken");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        SavedRequest savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        Intrinsics.checkNotNull((Object)auth);
        if (this.isAuthenticatedUser(auth) && !response.isCommitted()) {
            SavedRequestAwareAuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
            successHandler.setDefaultTargetUrl(this.getSystemDomainPrefix());
            successHandler.setAlwaysUseDefaultTargetUrl(false);
            successHandler.onAuthenticationSuccess(request, response, auth);
        }
        if (!auth.isAuthenticated() && auth instanceof TOTPAuthentication) {
            this.getDefaultRedirectStrategy().sendRedirect(request, response, "/totp/login");
        }
        String[] stringArray = this.getEnv().getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        ModelExtensionsKt.set((Model)model, (String)"devMode", (Object)ArraysKt.contains((Object[])stringArray, (Object)"dev"));
        ModelExtensionsKt.set((Model)model, (String)"csrf", (Object)csrfToken.getToken());
        Object object = savedRequest;
        ModelExtensionsKt.set((Model)model, (String)"isMobileClient", (Object)(object != null && (object = object.getRedirectUrl()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"just-login-mobile", (boolean)false, (int)2, null) : false));
        return "login";
    }

    private final boolean isAuthenticatedUser(Authentication auth) {
        return auth.isAuthenticated() && (auth instanceof UsernamePasswordAuthenticationToken || auth instanceof JwtAuthenticationToken || auth.getPrincipal() instanceof JustUser);
    }
}

