/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant.persistence;

import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.mybatis.mapper.TenantPermissionMapper;
import de.justsoftware.admin.mybatis.toolbox.DAOSupport;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.session.ResultHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\u0007\u001a\u00020\b2!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\b0\nH\u0016J\u0013\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0097\u0001J'\u0010\u0012\u001a\u00020\b2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0097\u0001J\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0097\u0001J\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u0097\u0001J#\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001b2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0097\u0001J#\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0097\u0001J\u0017\u0010\u0007\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0097\u0001J'\u0010\u001f\u001a\u00020\b2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0097\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/admin/domain/tenant/persistence/TenantPermissionRepository;", "Lde/justsoftware/admin/mybatis/mapper/TenantPermissionMapper;", "mapper", "daoSupport", "Lde/justsoftware/admin/mybatis/toolbox/DAOSupport;", "<init>", "(Lde/justsoftware/admin/mybatis/mapper/TenantPermissionMapper;Lde/justsoftware/admin/mybatis/toolbox/DAOSupport;)V", "forEach", "", "consumer", "Lkotlin/Function1;", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "Lkotlin/ParameterName;", "name", "tenantPermission", "deleteManyBy", "granteeId", "", "deleteOne", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "role", "Lde/justsoftware/admin/model/Role;", "findBy", "", "findByTenantId", "findByTenantIdAndGranteeId", "", "findByTenantIdAndPermission", "resultHandler", "Lorg/apache/ibatis/session/ResultHandler;", "upsert", "admin-service"})
public class TenantPermissionRepository
implements TenantPermissionMapper {
    @NotNull
    private final TenantPermissionMapper mapper;
    @NotNull
    private final DAOSupport daoSupport;

    public TenantPermissionRepository(@NotNull TenantPermissionMapper mapper, @NotNull DAOSupport daoSupport) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)daoSupport, (String)"daoSupport");
        this.mapper = mapper;
        this.daoSupport = daoSupport;
    }

    public void forEach(@NotNull Function1<? super TenantPermission, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.daoSupport.forAll(arg_0 -> TenantPermissionRepository.forEach$lambda$0(consumer, arg_0), arg_0 -> ((TenantPermissionMapper)this.mapper).forEach(arg_0));
    }

    @Delete(value={"\n        DELETE FROM tenant_permission\n            WHERE tenant_id = #{tenantId}\n            AND grantee_id = #{granteeId}\n            AND role = #{role}\n        "})
    public void deleteOne(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="granteeId") @NotNull String granteeId, @Param(value="role") @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this.mapper.deleteOne(tenantId, granteeId, role);
    }

    @Delete(value={"\n        DELETE FROM tenant_permission\n            WHERE grantee_id = #{granteeId}\n        "})
    public void deleteManyBy(@Param(value="granteeId") @NotNull String granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        this.mapper.deleteManyBy(granteeId);
    }

    @Select(value={"\n        SELECT * FROM tenant_permission\n            WHERE grantee_id = #{granteeId}\n        "})
    @NotNull
    public List<TenantPermission> findBy(@Param(value="granteeId") @NotNull String granteeId) {
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        return this.mapper.findBy(granteeId);
    }

    @Select(value={"\n        SELECT * FROM tenant_permission\n            WHERE tenant_id = #{tenantId}\n        "})
    @NotNull
    public List<TenantPermission> findByTenantId(@Param(value="tenantId") @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.mapper.findByTenantId(tenantId);
    }

    @Select(value={"\n        SELECT * FROM tenant_permission\n            WHERE tenant_id = #{tenantId}\n            AND role = #{role}\n        "})
    @NotNull
    public List<TenantPermission> findByTenantIdAndPermission(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="role") @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        return this.mapper.findByTenantIdAndPermission(tenantId, role);
    }

    @Select(value={"\n        SELECT * FROM tenant_permission\n            WHERE tenant_id = #{tenantId}\n            AND grantee_id = #{granteeId}\n        "})
    @NotNull
    public Set<TenantPermission> findByTenantIdAndGranteeId(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="granteeId") @NotNull String granteeId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        return this.mapper.findByTenantIdAndGranteeId(tenantId, granteeId);
    }

    @Select(value={"SELECT * FROM tenant_permission"})
    @ResultType(value=TenantPermission.class)
    public void forEach(@NotNull ResultHandler<TenantPermission> resultHandler) {
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        this.mapper.forEach(resultHandler);
    }

    @Insert(value={"\n        <script>\n\n        <if test=\"_databaseId == 'POSTGRES'\">\n            INSERT INTO tenant_permission (tenant_id, grantee_id, role)\n                VALUES (#{tenantId}, #{granteeId}, #{role})\n            ON CONFLICT(tenant_id, grantee_id, role)\n                DO NOTHING\n        </if>\n\n        <if test=\"_databaseId == 'ORACLE'\">\n            MERGE INTO tenant_permission p USING\n                (SELECT #{tenantId} as tenantId, #{granteeId} as granteeId, #{role} as role from dual) t\n            ON (t.tenantId = p.tenant_id AND t.granteeId = p.grantee_id AND t.role = p.role)\n            WHEN NOT MATCHED THEN\n                INSERT (tenant_id, grantee_id, role)\n                VALUES (#{tenantId}, #{granteeId}, #{role})\n        </if>\n\n        </script>\n        "})
    public void upsert(@Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="granteeId") @NotNull String granteeId, @Param(value="role") @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        this.mapper.upsert(tenantId, granteeId, role);
    }

    private static final void forEach$lambda$0(Function1 $tmp0, TenantPermission p0) {
        $tmp0.invoke((Object)p0);
    }
}

