/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.storage.CoverageSubset;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class CoverageQuery
extends Query
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4296814883807414158L;
    private GridGeometry domain;
    private int[] range;
    private String[] rangeNames;
    private int sourceDomainExpansion;

    @Override
    public void setSelection(Envelope envelope) {
        GridGeometry gridGeometry = null;
        if (envelope != null) {
            gridGeometry = new GridGeometry(null, null, envelope, GridRoundingMode.NEAREST);
        }
        this.setSelection(gridGeometry);
    }

    public void setSelection(GridGeometry gridGeometry) {
        this.domain = gridGeometry;
    }

    public GridGeometry getSelection() {
        return this.domain;
    }

    @Override
    public void setProjection(String ... stringArray) {
        if (stringArray != null) {
            stringArray = (String[])stringArray.clone();
            ArgumentChecks.ensureNonEmpty("range", stringArray);
        }
        this.rangeNames = stringArray;
        this.range = null;
    }

    public void setProjection(int ... nArray) {
        if (nArray != null) {
            nArray = (int[])nArray.clone();
            ArgumentChecks.ensureNonEmpty("range", nArray, 0, Integer.MAX_VALUE, true);
        }
        this.range = nArray;
        this.rangeNames = null;
    }

    public int[] getProjection() {
        return this.range != null ? (int[])this.range.clone() : null;
    }

    private void namesToIndices(GridCoverageResource gridCoverageResource) throws DataStoreException {
        if (this.rangeNames != null) {
            List<SampleDimension> list = gridCoverageResource.getSampleDimensions();
            int n = list.size();
            this.range = new int[this.rangeNames.length];
            for (int i = 0; i < this.rangeNames.length; ++i) {
                int n2;
                block4: {
                    String string = this.rangeNames[i];
                    for (n2 = 0; n2 < n; ++n2) {
                        if (!string.equals(list.get(n2).getName().toString())) {
                            continue;
                        }
                        break block4;
                    }
                    InternationalString internationalString = gridCoverageResource.getIdentifier().map(GenericName::toInternationalString).orElseGet(() -> Vocabulary.formatInternational((short)208));
                    throw new UnsupportedQueryException(Errors.format((short)120, internationalString, string));
                }
                this.range[i] = n2;
            }
            this.rangeNames = null;
        }
    }

    public void setSourceDomainExpansion(int n) {
        ArgumentChecks.ensurePositive("margin", n);
        this.sourceDomainExpansion = n;
    }

    public int getSourceDomainExpansion() {
        return this.sourceDomainExpansion;
    }

    protected GridCoverageResource execute(GridCoverageResource gridCoverageResource) throws DataStoreException {
        ArgumentChecks.ensureNonNull("source", gridCoverageResource);
        CoverageQuery coverageQuery = this.clone();
        coverageQuery.namesToIndices(gridCoverageResource);
        return new CoverageSubset(gridCoverageResource, coverageQuery);
    }

    public CoverageQuery clone() {
        try {
            return (CoverageQuery)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public int hashCode() {
        return 59 * Objects.hashCode(this.domain) + 37 * Arrays.hashCode(this.range) + 31 * this.sourceDomainExpansion;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            CoverageQuery coverageQuery = (CoverageQuery)object;
            return this.sourceDomainExpansion == coverageQuery.sourceDomainExpansion && Objects.equals(this.domain, coverageQuery.domain) && Arrays.equals(this.range, coverageQuery.range);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("SELECT ");
        if (this.range != null) {
            stringBuffer.append("range[");
            for (int i = 0; i < this.range.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.range[i]);
            }
            stringBuffer.append(']');
        } else {
            stringBuffer.append('*');
        }
        if (this.domain != null) {
            stringBuffer.append(" WHERE domain \u2229 [");
            GeographicBoundingBox geographicBoundingBox = this.domain.getGeographicExtent().orElse(null);
            if (geographicBoundingBox != null) {
                AngleFormat angleFormat = new AngleFormat("D\u00b0");
                CoverageQuery.append(stringBuffer, angleFormat, new Latitude(geographicBoundingBox.getSouthBoundLatitude()), new Latitude(geographicBoundingBox.getNorthBoundLatitude()));
                CoverageQuery.append(stringBuffer, angleFormat, new Longitude(geographicBoundingBox.getWestBoundLongitude()), new Longitude(geographicBoundingBox.getEastBoundLongitude()));
            } else {
                stringBuffer.append('?');
            }
            stringBuffer.append(']');
            if (this.sourceDomainExpansion != 0) {
                stringBuffer.append(" + margin(").append(this.sourceDomainExpansion).append(')');
            }
        }
        return stringBuffer.toString();
    }

    private static void append(StringBuffer stringBuffer, AngleFormat angleFormat, Angle angle, Angle angle2) {
        double d = Math.abs(angle2.degrees() - angle.degrees()) / 1000.0;
        angleFormat.setPrecision(d > 0.0 && d < Double.POSITIVE_INFINITY ? d : 0.0, false);
        angleFormat.setRoundingMode(RoundingMode.DOWN);
        angleFormat.format(angle, stringBuffer, null);
        angleFormat.setRoundingMode(RoundingMode.UP);
        angleFormat.format(angle2, stringBuffer, null);
    }
}

