/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.impl.NodeValueFetcher;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.AttributeFetcher;
import org.apache.solr.cluster.placement.AttributeValues;
import org.apache.solr.cluster.placement.CollectionMetrics;
import org.apache.solr.cluster.placement.NodeMetric;
import org.apache.solr.cluster.placement.ReplicaMetric;
import org.apache.solr.cluster.placement.impl.AttributeValuesImpl;
import org.apache.solr.cluster.placement.impl.CollectionMetricsBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeFetcherImpl
implements AttributeFetcher {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Set<String> requestedNodeSystemSnitchTags = new HashSet<String>();
    Set<NodeMetric<?>> requestedNodeMetricSnitchTags = new HashSet();
    Map<SolrCollection, Set<ReplicaMetric<?>>> requestedCollectionMetrics = new HashMap();
    Set<Node> nodes = Collections.emptySet();
    private final SolrCloudManager cloudManager;

    AttributeFetcherImpl(SolrCloudManager cloudManager) {
        this.cloudManager = cloudManager;
    }

    @Override
    public AttributeFetcher requestNodeSystemProperty(String name) {
        this.requestedNodeSystemSnitchTags.add(AttributeFetcherImpl.getSystemPropertySnitchTag(name));
        return this;
    }

    @Override
    public AttributeFetcher requestNodeMetric(NodeMetric<?> metric) {
        this.requestedNodeMetricSnitchTags.add(metric);
        return this;
    }

    @Override
    public AttributeFetcher requestCollectionMetrics(SolrCollection solrCollection, Set<ReplicaMetric<?>> metrics) {
        if (!metrics.isEmpty()) {
            this.requestedCollectionMetrics.put(solrCollection, Set.copyOf(metrics));
        }
        return this;
    }

    @Override
    public AttributeFetcher fetchFrom(Set<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    @Override
    public AttributeValues fetchAttributes() {
        HashMap<String, Map<Node, String>> systemSnitchToNodeToValue = new HashMap<String, Map<Node, String>>();
        HashMap metricSnitchToNodeToValue = new HashMap();
        HashMap<String, CollectionMetricsBuilder> collectionMetricsBuilders = new HashMap<String, CollectionMetricsBuilder>();
        HashMap nodeToReplicaInternalTags = new HashMap();
        Map<String, Set> requestedCollectionNamesMetrics = this.requestedCollectionMetrics.entrySet().stream().collect(Collectors.toMap(e -> ((SolrCollection)e.getKey()).getName(), e -> (Set)e.getValue()));
        HashMap<String, BiConsumer<Node, Object>> allSnitchTagsToInsertion = new HashMap<String, BiConsumer<Node, Object>>();
        for (String string : this.requestedNodeSystemSnitchTags) {
            HashMap sysPropMap = new HashMap();
            systemSnitchToNodeToValue.put(string, sysPropMap);
            allSnitchTagsToInsertion.put(string, (node, value) -> sysPropMap.put(node, (String)value));
        }
        for (NodeMetric nodeMetric : this.requestedNodeMetricSnitchTags) {
            HashMap metricMap = new HashMap();
            metricSnitchToNodeToValue.put(nodeMetric, metricMap);
            String metricSnitch = AttributeFetcherImpl.getMetricTag(nodeMetric);
            allSnitchTagsToInsertion.put(metricSnitch, (node, value) -> metricMap.put(node, metric.convert(value)));
        }
        this.requestedCollectionMetrics.forEach((collection, tags) -> {
            Set collectionTags = tags.stream().map(tag -> tag.getInternalName()).collect(Collectors.toSet());
            collection.shards().forEach(shard -> shard.replicas().forEach(replica -> {
                Set perNodeInternalTags = nodeToReplicaInternalTags.computeIfAbsent(replica.getNode(), n -> new HashSet());
                perNodeInternalTags.addAll(collectionTags);
            }));
        });
        for (Node node2 : this.nodes) {
            Map tagValues = this.cloudManager.getNodeStateProvider().getNodeValues(node2.getName(), allSnitchTagsToInsertion.keySet());
            for (Map.Entry entry2 : tagValues.entrySet()) {
                String tag = (String)entry2.getKey();
                Object value2 = entry2.getValue();
                BiConsumer inserter = (BiConsumer)allSnitchTagsToInsertion.get(tag);
                if (inserter != null) {
                    inserter.accept(node2, value2);
                    continue;
                }
                log.error("Received unsolicited snitch tag {} from node {}", (Object)tag, (Object)node2);
            }
        }
        for (Node node3 : nodeToReplicaInternalTags.keySet()) {
            Set tags2 = (Set)nodeToReplicaInternalTags.get(node3);
            Map infos = this.cloudManager.getNodeStateProvider().getReplicaInfo(node3.getName(), (Collection)tags2);
            infos.entrySet().stream().filter(entry -> requestedCollectionNamesMetrics.containsKey(entry.getKey())).forEach(entry -> {
                CollectionMetricsBuilder collectionMetricsBuilder = collectionMetricsBuilders.computeIfAbsent((String)entry.getKey(), c -> new CollectionMetricsBuilder());
                ((Map)entry.getValue()).forEach((shardName, replicas) -> {
                    CollectionMetricsBuilder.ShardMetricsBuilder shardMetricsBuilder = collectionMetricsBuilder.getShardMetricsBuilders().computeIfAbsent((String)shardName, s -> new CollectionMetricsBuilder.ShardMetricsBuilder((String)s));
                    replicas.forEach(replica -> {
                        CollectionMetricsBuilder.ReplicaMetricsBuilder replicaMetricsBuilder = shardMetricsBuilder.getReplicaMetricsBuilders().computeIfAbsent(replica.getName(), n -> new CollectionMetricsBuilder.ReplicaMetricsBuilder((String)n));
                        replicaMetricsBuilder.setLeader(replica.isLeader());
                        if (replica.isLeader()) {
                            shardMetricsBuilder.setLeaderMetrics(replicaMetricsBuilder);
                        }
                        Set requestedMetrics = (Set)requestedCollectionNamesMetrics.get(replica.getCollection());
                        requestedMetrics.forEach(metric -> replicaMetricsBuilder.addMetric((ReplicaMetric<?>)metric, replica.get(metric.getInternalName())));
                    });
                });
            });
        }
        HashMap<String, CollectionMetrics> collectionMetrics = new HashMap<String, CollectionMetrics>();
        collectionMetricsBuilders.forEach((name, builder) -> collectionMetrics.put((String)name, builder.build()));
        return new AttributeValuesImpl(systemSnitchToNodeToValue, metricSnitchToNodeToValue, collectionMetrics);
    }

    private static SolrInfoBean.Group getGroupFromMetricRegistry(NodeMetric.Registry registry) {
        switch (registry) {
            case SOLR_JVM: {
                return SolrInfoBean.Group.jvm;
            }
            case SOLR_NODE: {
                return SolrInfoBean.Group.node;
            }
            case SOLR_JETTY: {
                return SolrInfoBean.Group.jetty;
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported registry value " + registry);
    }

    public static String getMetricTag(NodeMetric<?> metric) {
        if (metric.getRegistry() != NodeMetric.Registry.UNSPECIFIED) {
            return "metrics:" + SolrMetricManager.getRegistryName(AttributeFetcherImpl.getGroupFromMetricRegistry(metric.getRegistry()), new String[0]) + ":" + metric.getInternalName();
        }
        if (NodeValueFetcher.tags.contains(metric.getInternalName())) {
            return metric.getInternalName();
        }
        return "metrics:" + metric.getInternalName();
    }

    public static String getSystemPropertySnitchTag(String name) {
        return "sysprop." + name;
    }
}

