/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.AnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;
import io.opentelemetry.extension.incubator.logs.AnyValue;
import io.opentelemetry.proto.common.v1.internal.ArrayValue;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

final class ArrayAnyValueMarshaler
extends MarshalerWithSize {
    private final Marshaler value;

    private ArrayAnyValueMarshaler(ArrayValueMarshaler value) {
        super(ArrayAnyValueMarshaler.calculateSize((Marshaler)value));
        this.value = value;
    }

    static MarshalerWithSize createAnyValue(List<AnyValue<?>> values) {
        return ArrayAnyValueMarshaler.createInternal(values, AnyValueMarshaler::create);
    }

    static MarshalerWithSize createString(List<String> values) {
        return ArrayAnyValueMarshaler.createInternal(values, StringAnyValueMarshaler::create);
    }

    static MarshalerWithSize createBool(List<Boolean> values) {
        return ArrayAnyValueMarshaler.createInternal(values, BoolAnyValueMarshaler::create);
    }

    static MarshalerWithSize createInt(List<Long> values) {
        return ArrayAnyValueMarshaler.createInternal(values, IntAnyValueMarshaler::create);
    }

    static MarshalerWithSize createDouble(List<Double> values) {
        return ArrayAnyValueMarshaler.createInternal(values, DoubleAnyValueMarshaler::create);
    }

    private static <T, M extends MarshalerWithSize> MarshalerWithSize createInternal(List<T> values, Function<T, M> initializer) {
        int len = values.size();
        Marshaler[] marshalers = new Marshaler[len];
        for (int i = 0; i < len; ++i) {
            marshalers[i] = (Marshaler)initializer.apply(values.get(i));
        }
        return new ArrayAnyValueMarshaler(new ArrayValueMarshaler(marshalers));
    }

    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(io.opentelemetry.proto.common.v1.internal.AnyValue.ARRAY_VALUE, this.value);
    }

    private static int calculateSize(Marshaler value) {
        return MarshalerUtil.sizeMessage((ProtoFieldInfo)io.opentelemetry.proto.common.v1.internal.AnyValue.ARRAY_VALUE, (Marshaler)value);
    }

    private static class ArrayValueMarshaler
    extends MarshalerWithSize {
        private final Marshaler[] values;

        private ArrayValueMarshaler(Marshaler[] values) {
            super(ArrayValueMarshaler.calculateSize(values));
            this.values = values;
        }

        public void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(ArrayValue.VALUES, this.values);
        }

        private static int calculateSize(Marshaler[] values) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ArrayValue.VALUES, (Marshaler[])values);
        }
    }
}

