/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config.search;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpJdkSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class SolrClientConfiguration {
    private final Logger _log = LoggerFactory.getLogger(this.getClass());
    private final SolrClient _solrClient;

    public SolrClientConfiguration(@Value(value="${SOLR.writePeopleUrl}") String solrUrl, @Value(value="${just.solr.username}") String username, @Value(value="${just.solr.password}") String password) {
        this._log.info("solrUrl: " + solrUrl);
        this._solrClient = ((HttpJdkSolrClient.Builder)((HttpJdkSolrClient.Builder)new HttpJdkSolrClient.Builder(solrUrl).withBasicAuthCredentials(username, password)).useHttp1_1(true)).build();
    }

    @Nonnull
    @Bean
    public SolrClient getSolrClient() {
        return this._solrClient;
    }
}

