/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.people.application.model.FacetFilterModel;
import de.justsoftware.people.application.model.SearchFilterModel;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileSearchModel {
    public static final ProfileSearchModel EMPTY = new ProfileSearchModel(null, null, null);
    private final String _searchString;
    private final ImmutableList<SearchFilterModel> _searchFilter;
    private final FacetFilterModel _facetFilter;

    @JsonCreator
    public ProfileSearchModel(@Nullable @JsonProperty(value="searchString") String searchString, @Nullable @JsonProperty(value="searchFilter") List<SearchFilterModel> searchFilter, @Nullable @JsonProperty(value="facetFilter") FacetFilterModel facetFilter) {
        this._searchString = Strings.nullToEmpty((String)searchString);
        this._searchFilter = searchFilter == null ? ImmutableList.of() : ImmutableList.copyOf(searchFilter);
        this._facetFilter = facetFilter;
    }

    @Nonnull
    public String getSearchString() {
        return this._searchString;
    }

    @Nonnull
    public ImmutableList<SearchFilterModel> getSearchFilter() {
        return this._searchFilter;
    }

    @CheckForNull
    public FacetFilterModel getFacetFilter() {
        return this._facetFilter;
    }
}

