/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class MigrationManifest {
    private final int totalRecords;
    private final int totalBatches;
    private final long totalBatchDurationsNs;
    private final long durationNanos;
    private final Map<MetadataRecordType, Integer> recordTypeCounts;

    MigrationManifest(int totalRecords, int totalBatches, long totalBatchDurationsNs, long durationNanos, Map<MetadataRecordType, Integer> recordTypeCounts) {
        this.totalRecords = totalRecords;
        this.totalBatches = totalBatches;
        this.totalBatchDurationsNs = totalBatchDurationsNs;
        this.durationNanos = durationNanos;
        this.recordTypeCounts = Collections.unmodifiableMap(recordTypeCounts);
    }

    public static Builder newBuilder(Time time) {
        return new Builder(time);
    }

    public long durationMs() {
        return TimeUnit.NANOSECONDS.toMillis(this.durationNanos);
    }

    public double avgBatchDurationMs() {
        if (this.totalBatches == 0) {
            return -1.0;
        }
        return 1.0 * (double)TimeUnit.NANOSECONDS.toMillis(this.totalBatchDurationsNs) / (double)this.totalBatches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationManifest that = (MigrationManifest)o;
        return this.totalRecords == that.totalRecords && this.totalBatches == that.totalBatches && this.totalBatchDurationsNs == that.totalBatchDurationsNs && this.durationNanos == that.durationNanos && this.recordTypeCounts.equals(that.recordTypeCounts);
    }

    public int hashCode() {
        return Objects.hash(this.totalRecords, this.totalBatches, this.totalBatchDurationsNs, this.durationNanos, this.recordTypeCounts);
    }

    public String toString() {
        return String.format("%d records were generated in %d ms across %d batches. The average time spent waiting on a batch was %.2f ms. The record types were %s", this.totalRecords, this.durationMs(), this.totalBatches, this.avgBatchDurationMs(), this.recordTypeCounts);
    }

    public static class Builder {
        private final Time time;
        private final long startTimeNanos;
        private final Map<MetadataRecordType, Integer> counts = new HashMap<MetadataRecordType, Integer>();
        private int batches = 0;
        private int total = 0;
        private long batchDurationsNs = 0L;
        private long endTimeNanos = 0L;

        Builder(Time time) {
            this.time = time;
            this.startTimeNanos = time.nanoseconds();
        }

        public void acceptBatch(List<ApiMessageAndVersion> recordBatch, long durationNs) {
            ++this.batches;
            this.batchDurationsNs += durationNs;
            recordBatch.forEach(apiMessageAndVersion -> {
                MetadataRecordType type = MetadataRecordType.fromId(apiMessageAndVersion.message().apiKey());
                this.counts.merge(type, 1, Integer::sum);
                ++this.total;
            });
        }

        public MigrationManifest build() {
            if (this.endTimeNanos == 0L) {
                this.endTimeNanos = this.time.nanoseconds();
            }
            TreeMap<MetadataRecordType, Integer> orderedCounts = new TreeMap<MetadataRecordType, Integer>(this.counts);
            return new MigrationManifest(this.total, this.batches, this.batchDurationsNs, this.endTimeNanos - this.startTimeNanos, orderedCounts);
        }
    }
}

