/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.suppress.BufferConfigInternal;
import org.apache.kafka.streams.kstream.internals.suppress.BufferFullStrategy;

public class StrictBufferConfigImpl
extends BufferConfigInternal<Suppressed.StrictBufferConfig>
implements Suppressed.StrictBufferConfig {
    private final long maxRecords;
    private final long maxBytes;
    private final BufferFullStrategy bufferFullStrategy;
    private final Map<String, String> logConfig;

    public StrictBufferConfigImpl(long maxRecords, long maxBytes, BufferFullStrategy bufferFullStrategy, Map<String, String> logConfig) {
        this.maxRecords = maxRecords;
        this.maxBytes = maxBytes;
        this.bufferFullStrategy = bufferFullStrategy;
        this.logConfig = logConfig;
    }

    public StrictBufferConfigImpl() {
        this.maxRecords = Long.MAX_VALUE;
        this.maxBytes = Long.MAX_VALUE;
        this.bufferFullStrategy = BufferFullStrategy.SHUT_DOWN;
        this.logConfig = Collections.emptyMap();
    }

    @Override
    public Suppressed.StrictBufferConfig withMaxRecords(long recordLimit) {
        return new StrictBufferConfigImpl(recordLimit, this.maxBytes, this.bufferFullStrategy, this.getLogConfig());
    }

    @Override
    public Suppressed.StrictBufferConfig withMaxBytes(long byteLimit) {
        return new StrictBufferConfigImpl(this.maxRecords, byteLimit, this.bufferFullStrategy, this.getLogConfig());
    }

    @Override
    public long maxRecords() {
        return this.maxRecords;
    }

    @Override
    public long maxBytes() {
        return this.maxBytes;
    }

    @Override
    public BufferFullStrategy bufferFullStrategy() {
        return this.bufferFullStrategy;
    }

    @Override
    public Suppressed.StrictBufferConfig withLoggingDisabled() {
        return new StrictBufferConfigImpl(this.maxRecords, this.maxBytes, this.bufferFullStrategy, null);
    }

    @Override
    public Suppressed.StrictBufferConfig withLoggingEnabled(Map<String, String> config) {
        return new StrictBufferConfigImpl(this.maxRecords, this.maxBytes, this.bufferFullStrategy, config);
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.logConfig != null;
    }

    @Override
    public Map<String, String> getLogConfig() {
        return this.isLoggingEnabled() ? this.logConfig : Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictBufferConfigImpl that = (StrictBufferConfigImpl)o;
        return this.maxRecords == that.maxRecords && this.maxBytes == that.maxBytes && this.bufferFullStrategy == that.bufferFullStrategy && Objects.equals(this.getLogConfig(), ((StrictBufferConfigImpl)o).getLogConfig());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxRecords, this.maxBytes, this.bufferFullStrategy, this.getLogConfig()});
    }

    public String toString() {
        return "StrictBufferConfigImpl{maxKeys=" + this.maxRecords + ", maxBytes=" + this.maxBytes + ", bufferFullStrategy=" + (Object)((Object)this.bufferFullStrategy) + ", logConfig=" + this.getLogConfig().toString() + '}';
    }
}

