/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import com.google.common.base.Strings;
import de.justsoftware.wikiservice.kafka.KafkaConfigurationProvider;
import java.util.Properties;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"liquibase"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001d\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/wikiservice/kafka/KafkaConfigurationProvider;", "", "bootstrapServers", "", "maxChunkSize", "", "<init>", "(Ljava/lang/String;I)V", "consumerConfig", "Ljava/util/Properties;", "groupId", "producerConfig", "Companion", "wiki-service"})
public class KafkaConfigurationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String bootstrapServers;
    private final int maxChunkSize;
    @NotNull
    public static final String KAFKA_STRING_PRODUCER = "KAFKA_STRING_PRODUCER";
    private static final int KAFKA_PRODUCER_BUFFER_MEMORY = 0x2000000;
    private static final int KAFKA_PRODUCER_BATCH_SIZE = 16384;

    public KafkaConfigurationProvider(@Value(value="${kafka.bootstrapServers}") @Nullable String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:100}") int maxChunkSize) {
        this.bootstrapServers = bootstrapServers;
        this.maxChunkSize = maxChunkSize;
    }

    @Nullable
    public Properties consumerConfig(@Nullable String groupId) {
        Properties properties;
        if (Strings.isNullOrEmpty((String)this.bootstrapServers)) {
            properties = null;
        } else {
            Properties properties2;
            Properties $this$consumerConfig_u24lambda_u240 = properties2 = new Properties();
            boolean bl = false;
            $this$consumerConfig_u24lambda_u240.put("bootstrap.servers", this.bootstrapServers);
            $this$consumerConfig_u24lambda_u240.put("enable.auto.commit", "false");
            $this$consumerConfig_u24lambda_u240.put("auto.offset.reset", "earliest");
            $this$consumerConfig_u24lambda_u240.put("max.poll.records", (Object)this.maxChunkSize);
            if (groupId != null) {
                $this$consumerConfig_u24lambda_u240.put("group.id", groupId);
            }
            properties = properties2;
        }
        return properties;
    }

    @Nullable
    public Properties producerConfig() {
        Properties properties;
        if (Strings.isNullOrEmpty((String)this.bootstrapServers)) {
            properties = null;
        } else {
            Properties properties2;
            Properties $this$producerConfig_u24lambda_u241 = properties2 = new Properties();
            boolean bl = false;
            $this$producerConfig_u24lambda_u241.put("bootstrap.servers", this.bootstrapServers);
            $this$producerConfig_u24lambda_u241.put("acks", "all");
            $this$producerConfig_u24lambda_u241.put("retries", (Object)0);
            $this$producerConfig_u24lambda_u241.put("batch.size", (Object)16384);
            $this$producerConfig_u24lambda_u241.put("linger.ms", (Object)1);
            $this$producerConfig_u24lambda_u241.put("buffer.memory", (Object)0x2000000);
            properties = properties2;
        }
        return properties;
    }
}

