/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.exceptions.EmptyTitleOrDescriptionException;
import de.justsoftware.wikiservice.business.exceptions.WikiCoverImageNotImageException;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.business.model.WikiMoveTarget;
import de.justsoftware.wikiservice.business.model.WikiPreview;
import de.justsoftware.wikiservice.drive.DriveService;
import de.justsoftware.wikiservice.drive.model.InternalFileModel;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.DriveDocumentId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.model.WikiModifiedEvent;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.DbDeletion;
import de.justsoftware.wikiservice.persistence.model.DbWiki;
import de.justsoftware.wikiservice.persistence.model.DbWikiOverview;
import de.justsoftware.wikiservice.translation.TranslationService;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import de.justsoftware.wikiservice.util.SortUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0017J\"\u0010&\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00190'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0)H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016J4\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00190+2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010)2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010!\u001a\u00020\"H\u0016JH\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010!\u001a\u00020\"2\b\u0010>\u001a\u0004\u0018\u00010\u001bH\u0016J&\u0010?\u001a\b\u0012\u0004\u0012\u00020@0+2\u0006\u00108\u001a\u00020 2\u0006\u0010A\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0016J<\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00190+2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010)2\u0006\u0010C\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00190)2\u0006\u0010!\u001a\u00020\"H\u0016J&\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00190+2\u0006\u0010!\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0016J.\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00190+2\u0006\u0010!\u001a\u00020\"2\u0006\u0010C\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203H\u0016J6\u0010G\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\b\u0010H\u001a\u0004\u0018\u00010\u001b2\b\u0010I\u001a\u0004\u0018\u00010\u001b2\b\u0010J\u001a\u0004\u0018\u00010\u001e2\u0006\u0010K\u001a\u00020 H\u0017J\u0012\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010\u001bH\u0012J\u0018\u0010O\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010P\u001a\u00020QH\u0017J\u0016\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U0)H\u0017J\"\u0010V\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00190'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0)H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lde/justsoftware/wikiservice/business/WikiService;", "", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "translationService", "Lde/justsoftware/wikiservice/translation/TranslationService;", "driveService", "Lde/justsoftware/wikiservice/drive/DriveService;", "<init>", "(Lde/justsoftware/wikiservice/persistence/WikiRepository;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/translation/TranslationService;Lde/justsoftware/wikiservice/drive/DriveService;)V", "create", "Lde/justsoftware/wikiservice/business/model/Wiki;", "title", "", "description", "coverImageDocumentId", "Lde/justsoftware/wikiservice/model/DriveDocumentId;", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "read", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "readByIds", "", "wikiIds", "", "readAll", "", "streamAllIds", "Ljava/util/stream/Stream;", "Ljava/util/UUID;", "readByRoles", "roles", "Lde/justsoftware/permission/client/model/Role;", "page", "", "limit", "getPreviewPage", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/wikiservice/business/model/WikiPreview;", "profileId", "pageSize", "sortKey", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Sort;", "sortDirection", "Lde/justsoftware/wikiservice/persistence/model/DbWikiOverview$Companion$Direction;", "translationLanguage", "getWikiMoveTargets", "Lde/justsoftware/wikiservice/business/model/WikiMoveTarget;", "query", "readByRolesAndSubscriber", "subscriber", "findWikisByTenant", "readByTenant", "readByTenantAndSubscriber", "update", "newTitle", "newDescription", "newCoverImageDocumentId", "updater", "isNotNullButEmpty", "", "str", "delete", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "removeDeletedWikis", "", "deletions", "Lde/justsoftware/wikiservice/persistence/model/DbDeletion;", "getWikisByIds", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiService.kt\nde/justsoftware/wikiservice/business/WikiService\n+ 2 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,349:1\n7#2:350\n7#2:366\n7#2:378\n7#2:386\n7#2:390\n7#2:407\n7#2:411\n1628#3,3:351\n1557#3:358\n1628#3,3:359\n1557#3:362\n1628#3,3:363\n1628#3,3:367\n1557#3:370\n1628#3,3:371\n1557#3:374\n1628#3,3:375\n1628#3,3:379\n1557#3:382\n1628#3,3:383\n1628#3,3:387\n1628#3,3:391\n1611#3,9:394\n1863#3:403\n1864#3:405\n1620#3:406\n1628#3,3:408\n1628#3,3:412\n1246#3,4:417\n1246#3,4:423\n126#4:354\n153#4,3:355\n1#5:404\n462#6:415\n412#6:416\n477#6:421\n423#6:422\n*S KotlinDebug\n*F\n+ 1 WikiService.kt\nde/justsoftware/wikiservice/business/WikiService\n*L\n115#1:350\n133#1:366\n206#1:378\n227#1:386\n239#1:390\n338#1:407\n345#1:411\n115#1:351,3\n119#1:358\n119#1:359,3\n129#1:362\n129#1:363,3\n133#1:367,3\n167#1:370\n167#1:371,3\n205#1:374\n205#1:375,3\n206#1:379,3\n223#1:382\n223#1:383,3\n227#1:387,3\n239#1:391,3\n330#1:394,9\n330#1:403\n330#1:405\n330#1:406\n338#1:408,3\n345#1:412,3\n346#1:417,4\n347#1:423,4\n116#1:354\n116#1:355,3\n330#1:404\n346#1:415\n346#1:416\n347#1:421\n347#1:422\n*E\n"})
public class WikiService {
    @NotNull
    private final WikiRepository wikiRepository;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final TranslationService translationService;
    @NotNull
    private final DriveService driveService;

    public WikiService(@NotNull WikiRepository wikiRepository, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionService permissionService, @NotNull SubscriptionService subscriptionService, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull AuthorizationService authorizationService, @NotNull TranslationService translationService, @NotNull DriveService driveService) {
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)translationService, (String)"translationService");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        this.wikiRepository = wikiRepository;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionService = permissionService;
        this.subscriptionService = subscriptionService;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.authorizationService = authorizationService;
        this.translationService = translationService;
        this.driveService = driveService;
    }

    @Transactional
    @NotNull
    public Wiki create(@NotNull String title, @NotNull String description, @Nullable DriveDocumentId coverImageDocumentId, @NotNull ProfileId creator, @NotNull TenantId tenantId) {
        Wiki wiki;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        if (StringsKt.isBlank((CharSequence)title) || StringsKt.isBlank((CharSequence)description)) {
            throw new EmptyTitleOrDescriptionException();
        }
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        WikiId wikiId = new WikiId(uUID);
        if (coverImageDocumentId != null) {
            String string = coverImageDocumentId.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            InternalFileModel attachment = this.driveService.persistFile(string, wikiId.toString(), creator);
            if (!StringsKt.startsWith$default((String)attachment.getMimeType(), (String)"image/", (boolean)false, (int)2, null)) {
                boolean bl = false;
                throw new WikiCoverImageNotImageException();
            }
        }
        DriveDocumentId driveDocumentId = coverImageDocumentId;
        Object object = this.wikiRepository.saveAndFlush((Object)new DbWiki(wikiId.getId(), ((Object)StringsKt.trim((CharSequence)title)).toString(), description, driveDocumentId != null ? driveDocumentId.getId() : null, tenantId.getId(), creator.getId(), null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"saveAndFlush(...)");
        Wiki it = wiki = DbWiki.Companion.toWiki((DbWiki)object);
        boolean bl = false;
        WikiId wikiId2 = it.getId();
        this.permissionService.addPermissionItemForNewWiki(wikiId2, tenantId);
        this.subscriptionService.setSubscription((ItemId)wikiId2, creator, true);
        it = wiki;
        boolean bl2 = false;
        this.transactionUtils.afterCommit(() -> WikiService.create$lambda$3$lambda$2(this, it));
        return wiki;
    }

    @Transactional
    @NotNull
    public Wiki read(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Object object = this.wikiRepository.getReferenceById((Object)wikiId.getId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        return DbWiki.Companion.toWiki((DbWiki)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Wiki> readByIds(@NotNull Set<WikiId> wikiIds) {
        Map map;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        if (wikiIds.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            Object it;
            Object item$iv$iv;
            Map $this$mapTo$iv$iv;
            void $this$mapToSet$iv;
            Iterable iterable = wikiIds;
            Object object = this.wikiRepository;
            boolean $i$f$mapToSet = false;
            void var4_5 = $this$mapToSet$iv;
            Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                WikiId wikiId = (WikiId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            Map $this$map$iv = object.findByIds((Set)destination$iv$iv);
            boolean $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                it = item$iv$iv = (Map.Entry)iterator.next();
                object = destination$iv$iv;
                boolean bl = false;
                object.add(TuplesKt.to((Object)new WikiId((UUID)it.getKey()), (Object)DbWiki.Companion.toWiki((DbWiki)it.getValue())));
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Wiki> readAll() {
        void $this$mapTo$iv$iv;
        List list = this.wikiRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbWiki dbWiki = (DbWiki)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(DbWiki.Companion.toWiki((DbWiki)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Stream<UUID> streamAllIds() {
        return this.wikiRepository.streamAllIds();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Wiki> readByRoles(@NotNull Set<Role> roles, int page, int limit, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = roles;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void r;
            Role role = (Role)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = it;
        WikiRepository wikiRepository = this.wikiRepository;
        boolean $i$f$mapToSet = false;
        item$iv$iv2 = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void grantee;
            GranteeId granteeId = (GranteeId)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(grantee.getGranteeId());
        }
        UUID uUID = tenantId.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<Wiki> list = wikiRepository.findAllByPermissionRoles((Set)destination$iv$iv2, uUID, (Pageable)pageRequest).get().map(arg_0 -> WikiService.readByRoles$lambda$11(WikiService::readByRoles$lambda$10, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<WikiPreview> getPreviewPage(@NotNull ProfileId profileId, int page, int pageSize, @NotNull DbWikiOverview.Companion.Sort sortKey, @NotNull DbWikiOverview.Companion.Direction sortDirection, @NotNull TenantId tenantId, @Nullable String translationLanguage) {
        Page page2;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)sortKey, (String)"sortKey");
        Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        boolean isTenantManager = (Boolean)MapsKt.getValue((Map)this.authorizationService.mayTenantManageWikis(SetsKt.setOf((Object)tenantId), profileId), (Object)tenantId);
        PageRequest pageRequest = PageRequest.of((int)page, (int)pageSize, (Sort)SortUtilsKt.getSort((DbWikiOverview.Companion.Sort)sortKey, (DbWikiOverview.Companion.Direction)sortDirection));
        if (isTenantManager) {
            long l = profileId.getId();
            UUID uUID = tenantId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            page2 = this.wikiRepository.findWikiPreviewsByProfileAndTenant(l, uUID, (Pageable)pageRequest);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.authorizationService.getUserRoles(profileId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Role role = (Role)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(GranteeId.Companion.toGranteeId((Role)it).getGranteeId());
            }
            Set granteeIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            long l = profileId.getId();
            UUID uUID = tenantId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            page2 = this.wikiRepository.findWikiPreviewsByRolesAndTenantAndProfile(granteeIds, l, uUID, (Pageable)pageRequest);
        }
        Page result = page2;
        List list = result.toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return (Page)new PageImpl(this.translationService.translate(list, translationLanguage, tenantId), result.getPageable(), result.getTotalElements());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<WikiMoveTarget> getWikiMoveTargets(@NotNull ProfileId profileId, @NotNull String query, @NotNull TenantId tenantId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        boolean isTenantManager = (Boolean)MapsKt.getValue((Map)this.authorizationService.mayTenantManageWikis(SetsKt.setOf((Object)tenantId), profileId), (Object)tenantId);
        Sort.Order[] orderArray = new Sort.Order[]{Sort.Order.asc((String)"title")};
        PageRequest pageRequest = PageRequest.of((int)0, (int)30, (Sort)Sort.by((Sort.Order[])orderArray));
        if (isTenantManager) {
            UUID uUID = tenantId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            list = this.wikiRepository.findWikiMoveTargetsByTenant(uUID, query, (Pageable)pageRequest);
        } else {
            void $this$mapToSet$iv;
            GranteeId it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.authorizationService.getUserRoles(profileId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Role role = (Role)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(GranteeId.Companion.toGranteeId((Role)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$mapToSet = false;
            $this$mapTo$iv$iv = $this$mapToSet$iv;
            destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (GranteeId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getGranteeId());
            }
            Set granteeIds = (Set)destination$iv$iv;
            UUID uUID = tenantId.getId();
            Intrinsics.checkNotNull((Object)pageRequest);
            list = this.wikiRepository.findWikiMoveTargetsByRolesAndTenant(granteeIds, query, uUID, (Pageable)pageRequest);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Wiki> readByRolesAndSubscriber(@NotNull Set<Role> roles, @NotNull ProfileId subscriber, int page, int limit, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable iterable = roles;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void r;
            Role role = (Role)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        destination$iv$iv = it;
        WikiRepository wikiRepository = this.wikiRepository;
        boolean $i$f$mapToSet = false;
        item$iv$iv2 = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void grantee;
            GranteeId granteeId = (GranteeId)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(grantee.getGranteeId());
        }
        UUID uUID = tenantId.getId();
        long l = subscriber.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<Wiki> list = wikiRepository.findAllByPermissionRolesAndSubscriber((Set)destination$iv$iv2, uUID, l, (Pageable)pageRequest).get().map(arg_0 -> WikiService.readByRolesAndSubscriber$lambda$19(WikiService::readByRolesAndSubscriber$lambda$18, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Wiki> findWikisByTenant(@NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$mapToSet$iv = this.wikiRepository.findAllByTenantId(tenantId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbWiki dbWiki = (DbWiki)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbWiki.Companion.toWiki((DbWiki)it));
        }
        return (Set)destination$iv$iv;
    }

    @NotNull
    public List<Wiki> readByTenant(@NotNull TenantId tenantId, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        UUID uUID = tenantId.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List list = this.wikiRepository.findAllByTenantId(uUID, (Pageable)pageRequest).map(arg_0 -> WikiService.readByTenant$lambda$22(WikiService::readByTenant$lambda$21, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @NotNull
    public List<Wiki> readByTenantAndSubscriber(@NotNull TenantId tenantId, @NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        UUID uUID = tenantId.getId();
        long l = subscriber.getId();
        String[] stringArray = new String[]{"title"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List list = this.wikiRepository.findAllByTenantIdAndSubscriber(uUID, l, (Pageable)pageRequest).map(arg_0 -> WikiService.readByTenantAndSubscriber$lambda$24(WikiService::readByTenantAndSubscriber$lambda$23, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public Wiki update(@NotNull WikiId wikiId, @Nullable String newTitle, @Nullable String newDescription, @Nullable DriveDocumentId newCoverImageDocumentId, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (this.isNotNullButEmpty(newTitle) || this.isNotNullButEmpty(newDescription)) {
            throw new EmptyTitleOrDescriptionException();
        }
        Object object = this.wikiRepository.getReferenceById((Object)wikiId.getId());
        Object it = (DbWiki)object;
        boolean bl = false;
        if (newCoverImageDocumentId != null && !Intrinsics.areEqual((Object)newCoverImageDocumentId.getId(), (Object)it.getCoverImageDocumentId())) {
            String string = newCoverImageDocumentId.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            InternalFileModel attachment = this.driveService.persistFile(string, wikiId.toString(), updater);
            if (!StringsKt.startsWith$default((String)attachment.getMimeType(), (String)"image/", (boolean)false, (int)2, null)) {
                boolean bl2 = false;
                throw new WikiCoverImageNotImageException();
            }
        }
        DbWiki $this$update_u24lambda_u2427 = (DbWiki)object;
        boolean bl3 = false;
        if (newTitle != null) {
            $this$update_u24lambda_u2427.setTitle(((Object)StringsKt.trim((CharSequence)newTitle)).toString());
        }
        if (newDescription != null) {
            $this$update_u24lambda_u2427.setDescription(newDescription);
        }
        DriveDocumentId driveDocumentId = newCoverImageDocumentId;
        if (!Intrinsics.areEqual((Object)(driveDocumentId != null ? driveDocumentId.getId() : null), (Object)$this$update_u24lambda_u2427.getCoverImageDocumentId())) {
            DriveDocumentId driveDocumentId2 = newCoverImageDocumentId;
            $this$update_u24lambda_u2427.setCoverImageDocumentId(driveDocumentId2 != null ? driveDocumentId2.getId() : null);
        }
        $this$update_u24lambda_u2427.setModifiedBy(updater.getId());
        it = (DbWiki)object;
        boolean bl4 = false;
        Object object2 = this.wikiRepository.saveAndFlush(it);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"saveAndFlush(...)");
        object = DbWiki.Companion.toWiki((DbWiki)object2);
        it = object;
        boolean bl5 = false;
        this.transactionUtils.afterCommit(() -> WikiService.update$lambda$30$lambda$29(this, (Wiki)it));
        return object;
    }

    private boolean isNotNullButEmpty(String str) {
        return str != null && StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)str)).toString());
    }

    @Transactional
    @NotNull
    public Wiki delete(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Wiki wiki = this.read(wikiId);
        this.articleService.deleteWikiArticles(wikiId, deletionId);
        this.chapterService.deleteWikiChapters(wikiId, deletionId);
        this.permissionService.removePermissionsForDeletedWiki(wikiId);
        this.wikiRepository.deleteById((Object)wikiId.getId(), deletionId.getId());
        this.transactionUtils.afterCommit(() -> WikiService.delete$lambda$31(this, wikiId));
        return wiki;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeDeletedWikis(@NotNull Set<DbDeletion> deletions) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletions, (String)"deletions");
        Iterable $this$mapNotNull$iv = deletions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<WikiId> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WikiId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbDeletion it = (DbDeletion)element$iv$iv;
            boolean bl2 = false;
            if ((it.getItemType() == IdType.WIKI_WIKI ? new WikiId(it.getItemId()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set wikiIdsToRemovePermissionsFrom = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapToSet$iv = deletions;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (DbDeletion)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            UUID uUID = it.getId();
            if (uUID == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(uUID);
        }
        Set deletionIds = (Set)destination$iv$iv2;
        this.permissionService.removePermissionsForWikis(wikiIdsToRemovePermissionsFrom);
        this.wikiRepository.deleteAllByDeletionIds(deletionIds);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Wiki> getWikisByIds(@NotNull Set<WikiId> wikiIds) {
        void $this$mapKeysTo$iv$iv;
        Map.Entry it$iv$iv;
        Map.Entry entry;
        Map.Entry entry2;
        Object $this$mapValuesTo$iv$iv;
        Collection<Object> collection;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Iterable iterable = wikiIds;
        Object object = this.wikiRepository;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            WikiId wikiId = (WikiId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map $this$mapValues$iv = object.findByIds((Set)destination$iv$iv);
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            entry2 = (Map.Entry)element$iv$iv$iv;
            Object object2 = destination$iv$iv;
            boolean bl3 = false;
            entry = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object = object2;
            boolean bl2 = false;
            Wiki wiki = DbWiki.Companion.toWiki((DbWiki)it.getValue());
            object.put(collection, wiki);
        }
        Object $this$mapKeys$iv = destination$iv$iv;
        boolean $i$f$mapKeys = false;
        $this$mapValuesTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv2;
            void it;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            entry = new WikiId((UUID)it.getKey());
            Object object3 = object;
            boolean bl4 = false;
            entry2 = it$iv$iv2.getValue();
            object3.put(entry, entry2);
        }
        return destination$iv$iv;
    }

    private static final Unit create$lambda$3$lambda$2(WikiService this$0, Wiki $it) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Wiki readByRoles$lambda$10(DbWiki it) {
        Intrinsics.checkNotNull((Object)it);
        return DbWiki.Companion.toWiki(it);
    }

    private static final Wiki readByRoles$lambda$11(Function1 $tmp0, Object p0) {
        return (Wiki)$tmp0.invoke(p0);
    }

    private static final Wiki readByRolesAndSubscriber$lambda$18(DbWiki it) {
        Intrinsics.checkNotNull((Object)it);
        return DbWiki.Companion.toWiki(it);
    }

    private static final Wiki readByRolesAndSubscriber$lambda$19(Function1 $tmp0, Object p0) {
        return (Wiki)$tmp0.invoke(p0);
    }

    private static final Wiki readByTenant$lambda$21(DbWiki it) {
        Intrinsics.checkNotNull((Object)it);
        return DbWiki.Companion.toWiki(it);
    }

    private static final Wiki readByTenant$lambda$22(Function1 $tmp0, Object p0) {
        return (Wiki)$tmp0.invoke(p0);
    }

    private static final Wiki readByTenantAndSubscriber$lambda$23(DbWiki it) {
        Intrinsics.checkNotNull((Object)it);
        return DbWiki.Companion.toWiki(it);
    }

    private static final Wiki readByTenantAndSubscriber$lambda$24(Function1 $tmp0, Object p0) {
        return (Wiki)$tmp0.invoke(p0);
    }

    private static final Unit update$lambda$30$lambda$29(WikiService this$0, Wiki $it) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($it.getId()));
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$31(WikiService this$0, WikiId $wikiId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($wikiId));
        return Unit.INSTANCE;
    }
}

