/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.prosemirror.model.nodes;

import de.justsoftware.wikiservice.prosemirror.model.nodes.DriveDocument;
import de.justsoftware.wikiservice.prosemirror.model.nodes.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0006\u0010\u000f\u001a\u00020\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/wikiservice/prosemirror/model/nodes/DriveDocument;", "Lde/justsoftware/wikiservice/prosemirror/model/nodes/Node;", "title", "", "driveDocId", "type", "fileType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "getDriveDocId", "getType", "getFileType", "toDom", "toDriveLink", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "wiki-service"})
public final class DriveDocument
implements Node {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String driveDocId;
    @NotNull
    private final String type;
    @NotNull
    private final String fileType;

    public DriveDocument(@NotNull String title, @NotNull String driveDocId, @NotNull String type, @NotNull String fileType) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)driveDocId, (String)"driveDocId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.title = title;
        this.driveDocId = driveDocId;
        this.type = type;
        this.fileType = fileType;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getDriveDocId() {
        return this.driveDocId;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getFileType() {
        return this.fileType;
    }

    @NotNull
    public String toDom() {
        return "<a drive-doc-id=\"" + this.driveDocId + "\" file-type=\"" + this.fileType + "\" type=\"" + this.type + "\" title=\"" + this.title + "\" class=\"prosemirror__internal-link\" href=\"" + this.toDriveLink() + "\"><i class=\"fa-light fa-folder\"></i>" + this.title + "</a>";
    }

    @NotNull
    public final String toDriveLink() {
        Object object = new String[]{","};
        String uuid = (String)StringsKt.split$default((CharSequence)this.driveDocId, (String[])object, (boolean)false, (int)0, (int)6, null).get(1);
        return switch (this.type) {
            case "SHARE" -> "/drive/folder/" + uuid;
            case "FOLDER" -> "/drive/folder/" + uuid;
            case "DOCUMENT" -> "/drive/folder/" + uuid;
            default -> "/drive/folder/" + uuid;
        };
    }

    @NotNull
    public final String component1() {
        return this.title;
    }

    @NotNull
    public final String component2() {
        return this.driveDocId;
    }

    @NotNull
    public final String component3() {
        return this.type;
    }

    @NotNull
    public final String component4() {
        return this.fileType;
    }

    @NotNull
    public final DriveDocument copy(@NotNull String title, @NotNull String driveDocId, @NotNull String type, @NotNull String fileType) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)driveDocId, (String)"driveDocId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        return new DriveDocument(title, driveDocId, type, fileType);
    }

    public static /* synthetic */ DriveDocument copy$default(DriveDocument driveDocument, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = driveDocument.title;
        }
        if ((n & 2) != 0) {
            string2 = driveDocument.driveDocId;
        }
        if ((n & 4) != 0) {
            string3 = driveDocument.type;
        }
        if ((n & 8) != 0) {
            string4 = driveDocument.fileType;
        }
        return driveDocument.copy(string, string2, string3, string4);
    }

    @NotNull
    public String toString() {
        return "DriveDocument(title=" + this.title + ", driveDocId=" + this.driveDocId + ", type=" + this.type + ", fileType=" + this.fileType + ")";
    }

    public int hashCode() {
        int result = this.title.hashCode();
        result = result * 31 + this.driveDocId.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.fileType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DriveDocument)) {
            return false;
        }
        DriveDocument driveDocument = (DriveDocument)other;
        if (!Intrinsics.areEqual((Object)this.title, (Object)driveDocument.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.driveDocId, (Object)driveDocument.driveDocId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)driveDocument.type)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fileType, (Object)driveDocument.fileType);
    }
}

