/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.prosemirror.model.marks;

import de.justsoftware.wikiservice.prosemirror.model.marks.Link;
import de.justsoftware.wikiservice.prosemirror.model.marks.Mark;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0006\u0010\f\u001a\u00020\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/wikiservice/prosemirror/model/marks/Link;", "Lde/justsoftware/wikiservice/prosemirror/model/marks/Mark;", "href", "", "title", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getHref", "()Ljava/lang/String;", "getTitle", "toDom", "content", "hrefWithProtocol", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "wiki-service"})
public final class Link
implements Mark {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String href;
    @Nullable
    private final String title;
    @NotNull
    private static final Regex protocolRegex = new Regex("^(?:mailto:|tel:|(?:https?|ftp|file|notes|consense)://|#)");

    public Link(@NotNull String href, @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        this.href = href;
        this.title = title;
    }

    public /* synthetic */ Link(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final String getHref() {
        return this.href;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public String toDom(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = this.hrefWithProtocol();
        String string2 = this.title;
        if (string2 == null) {
            string2 = this.href;
        }
        return "<a href=\"" + string + "\" title=\"" + string2 + "\" target=\"_blank\" rel=\"noopener noreferrer\">" + content + "</a>";
    }

    @NotNull
    public final String hrefWithProtocol() {
        CharSequence charSequence = this.href;
        return protocolRegex.containsMatchIn(charSequence) ? this.href : "https://" + this.href;
    }

    @NotNull
    public final String component1() {
        return this.href;
    }

    @Nullable
    public final String component2() {
        return this.title;
    }

    @NotNull
    public final Link copy(@NotNull String href, @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        return new Link(href, title);
    }

    public static /* synthetic */ Link copy$default(Link link, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = link.href;
        }
        if ((n & 2) != 0) {
            string2 = link.title;
        }
        return link.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "Link(href=" + this.href + ", title=" + this.title + ")";
    }

    public int hashCode() {
        int result = this.href.hashCode();
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Link)) {
            return false;
        }
        Link link = (Link)other;
        if (!Intrinsics.areEqual((Object)this.href, (Object)link.href)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.title, (Object)link.title);
    }

    public static final /* synthetic */ Regex access$getProtocolRegex$cp() {
        return protocolRegex;
    }
}

