/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence.model;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.AuditModel;
import de.justsoftware.wikiservice.persistence.model.DbPermission;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="Permission")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\t\u0010\u000eR\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/wikiservice/persistence/model/DbPermission;", "Lde/justsoftware/wikiservice/persistence/model/AuditModel;", "id", "Ljava/util/UUID;", "wikiId", "type", "Lde/justsoftware/wikiservice/model/PermissionType;", "granteeId", "", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Lde/justsoftware/wikiservice/model/PermissionType;Ljava/lang/String;)V", "Lde/justsoftware/wikiservice/model/WikiId;", "role", "Lde/justsoftware/permission/client/model/Role;", "(Lde/justsoftware/wikiservice/model/WikiId;Lde/justsoftware/wikiservice/model/PermissionType;Lde/justsoftware/permission/client/model/Role;)V", "getId", "()Ljava/util/UUID;", "setId", "(Ljava/util/UUID;)V", "getWikiId", "setWikiId", "getType", "()Lde/justsoftware/wikiservice/model/PermissionType;", "setType", "(Lde/justsoftware/wikiservice/model/PermissionType;)V", "getGranteeId", "()Ljava/lang/String;", "setGranteeId", "(Ljava/lang/String;)V", "Companion", "wiki-service"})
public final class DbPermission
extends AuditModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Id
    @NotNull
    private UUID id;
    @NotNull
    private UUID wikiId;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private PermissionType type;
    @NotNull
    private String granteeId;

    public DbPermission(@NotNull UUID id, @NotNull UUID wikiId, @NotNull PermissionType type, @NotNull String granteeId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)granteeId, (String)"granteeId");
        this.id = id;
        this.wikiId = wikiId;
        this.type = type;
        this.granteeId = granteeId;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    public final void setId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.id = uUID;
    }

    @NotNull
    public final UUID getWikiId() {
        return this.wikiId;
    }

    public final void setWikiId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.wikiId = uUID;
    }

    @NotNull
    public final PermissionType getType() {
        return this.type;
    }

    public final void setType(@NotNull PermissionType permissionType) {
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"<set-?>");
        this.type = permissionType;
    }

    @NotNull
    public final String getGranteeId() {
        return this.granteeId;
    }

    public final void setGranteeId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.granteeId = string;
    }

    public DbPermission(@NotNull WikiId wikiId, @NotNull PermissionType type, @NotNull Role role) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this(uUID, wikiId.getId(), type, GranteeId.Companion.toGranteeId(role).getGranteeId());
    }

    public DbPermission() {
    }
}

