/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.controller;

import de.justsoftware.wikiservice.application.ConfigApplicationService;
import de.justsoftware.wikiservice.application.PermissionApplicationService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.kafka.DriveItemIdProducer;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Hidden
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\rH\u0017J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u000e\b\u0001\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0017J\u001c\u0010\u0015\u001a\u00020\r2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017J\u0012\u0010\u001a\u001a\u00020\u00192\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/wikiservice/controller/InternalWikiController;", "", "permissionApplicationService", "Lde/justsoftware/wikiservice/application/PermissionApplicationService;", "configApplicationService", "Lde/justsoftware/wikiservice/application/ConfigApplicationService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "driveItemIdProducer", "Lde/justsoftware/wikiservice/kafka/DriveItemIdProducer;", "<init>", "(Lde/justsoftware/wikiservice/application/PermissionApplicationService;Lde/justsoftware/wikiservice/application/ConfigApplicationService;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/kafka/DriveItemIdProducer;)V", "syncAllDriveItems", "", "publishAllPermissions", "getWikiNamesByIds", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "ids", "", "setArticleVersionHistoryReadPermission", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "permission", "Lde/justsoftware/wikiservice/model/PermissionType;", "getArticleVersionHistoryReadPermission", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nInternalWikiController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalWikiController.kt\nde/justsoftware/wikiservice/controller/InternalWikiController\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n462#2:53\n412#2:54\n1246#3,4:55\n*S KotlinDebug\n*F\n+ 1 InternalWikiController.kt\nde/justsoftware/wikiservice/controller/InternalWikiController\n*L\n39#1:53\n39#1:54\n39#1:55,4\n*E\n"})
public class InternalWikiController {
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final ConfigApplicationService configApplicationService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final DriveItemIdProducer driveItemIdProducer;

    public InternalWikiController(@NotNull PermissionApplicationService permissionApplicationService, @NotNull ConfigApplicationService configApplicationService, @NotNull WikiService wikiService, @NotNull DriveItemIdProducer driveItemIdProducer) {
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)configApplicationService, (String)"configApplicationService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)driveItemIdProducer, (String)"driveItemIdProducer");
        this.permissionApplicationService = permissionApplicationService;
        this.configApplicationService = configApplicationService;
        this.wikiService = wikiService;
        this.driveItemIdProducer = driveItemIdProducer;
    }

    @PostMapping(value={"drive/syncAllItems"})
    public void syncAllDriveItems() {
        this.driveItemIdProducer.syncAllItems();
    }

    @PostMapping(value={"publish/permissions"})
    public void publishAllPermissions() {
        this.permissionApplicationService.republishPermissions();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"wikiNamesByIds"})
    @NotNull
    public Map<WikiId, String> getWikiNamesByIds(@RequestBody @NotNull Set<WikiId> ids) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Map $this$mapValues$iv = this.wikiService.readByIds(CollectionsKt.toSet((Iterable)ids));
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String string = ((Wiki)it.getValue()).getTitle();
            map3.put(k, string);
        }
        return destination$iv$iv;
    }

    @PostMapping(value={"permissions/article_version_history/{tenantId}/{permission}"})
    public void setArticleVersionHistoryReadPermission(@PathVariable(value="tenantId") @NotNull TenantId tenantId, @PathVariable(value="permission") @NotNull PermissionType permission) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        this.configApplicationService.setArticleVersionHistoryReadPermission(tenantId, permission);
    }

    @GetMapping(value={"permissions/article_version_history/{tenantId}"})
    @NotNull
    public PermissionType getArticleVersionHistoryReadPermission(@PathVariable(value="tenantId") @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.configApplicationService.getArticleVersionHistoryReadPermission(tenantId);
    }
}

