/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.monitoring.business;

import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

@ParametersAreNonnullByDefault
public abstract class ToroHealthIndicator
extends AbstractHealthIndicator {
    private static final Logger LOG = LoggerFactory.getLogger(ToroHealthIndicator.class);

    void handleError(Health.Builder builder, String component, String message) {
        LOG.error("{} health check failed! {}", (Object)component, (Object)message);
        builder.down().withDetail("message", (Object)message);
    }

    void handleError(Health.Builder builder, String component, String message, Throwable e) {
        LOG.error("{} health check failed! For more details check debug log. {}", (Object)component, (Object)message);
        LOG.debug("{} health check failed!", (Object)component, (Object)e);
        builder.down().withDetail("message", (Object)message);
    }
}

