/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.config;

import de.justsoftware.publicAPI.config.ExceptionHandlerConfiguration;
import de.justsoftware.publicAPI.exception.ApolloErrorException;
import de.justsoftware.publicAPI.exception.MissingScopeException;
import de.justsoftware.publicAPI.exception.UnauthorizedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.validation.method.ParameterValidationResult;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.method.annotation.HandlerMethodValidationException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Configuration
@ControllerAdvice
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00172\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0014H\u0017\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration;", "", "<init>", "()V", "handleAllExceptions", "Lde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration$ErrorResponse;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleBadRequestExceptions", "Lde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration$ValidationErrors;", "handleUnauthorizedException", "Lde/justsoftware/publicAPI/exception/UnauthorizedException;", "handleMissingScopeExceptionException", "Lde/justsoftware/publicAPI/exception/MissingScopeException;", "handleValidationException", "Lorg/springframework/web/method/annotation/HandlerMethodValidationException;", "handleClientNotFoundException", "Lorg/springframework/web/client/HttpClientErrorException$NotFound;", "handleApolloErrorException", "Lde/justsoftware/publicAPI/exception/ApolloErrorException;", "ErrorResponse", "ValidationErrors", "Companion", "public-api-service"})
@SourceDebugExtension(value={"SMAP\nExceptionHandlerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/publicAPI/util/LoggerUtilsKt\n*L\n1#1,87:1\n1368#2:88\n1454#2,2:89\n1557#2:91\n1628#2,3:92\n1456#2,3:95\n8#3:98\n7#3,3:99\n*S KotlinDebug\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/publicAPI/config/ExceptionHandlerConfiguration\n*L\n62#1:88\n62#1:89,2\n62#1:91\n62#1:92,3\n62#1:95,3\n83#1:98\n83#1:99,3\n*E\n"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public ErrorResponse handleAllExceptions(@NotNull Exception e) {
        ErrorResponse errorResponse;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ErrorResponse it = errorResponse = new ErrorResponse(DEFAULT_ERROR);
        boolean bl = false;
        LOG.error(DEFAULT_ERROR, (Throwable)e);
        return errorResponse;
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, HttpMessageConversionException.class, IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @NotNull
    public ValidationErrors handleBadRequestExceptions(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ValidationErrors(CollectionsKt.listOf((Object)e.getMessage()));
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @NotNull
    public ErrorResponse handleUnauthorizedException(@NotNull UnauthorizedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ErrorResponse(e.getMessage());
    }

    @ExceptionHandler(value={MissingScopeException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @NotNull
    public ErrorResponse handleMissingScopeExceptionException(@NotNull MissingScopeException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ErrorResponse(e.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={HandlerMethodValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @NotNull
    public ValidationErrors handleValidationException(@NotNull HandlerMethodValidationException e) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List list = e.getParameterValidationResults();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameterValidationResults(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ParameterValidationResult results = (ParameterValidationResult)element$iv$iv;
            boolean bl = false;
            List list2 = results.getResolvableErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getResolvableErrors(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MessageSourceResolvable messageSourceResolvable = (MessageSourceResolvable)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getDefaultMessage());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List errors = (List)destination$iv$iv;
        return errors.isEmpty() ? new ValidationErrors(CollectionsKt.listOf((Object)e.getMessage())) : new ValidationErrors(errors);
    }

    @ExceptionHandler(value={HttpClientErrorException.NotFound.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    @NotNull
    public ErrorResponse handleClientNotFoundException(@NotNull HttpClientErrorException.NotFound e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ErrorResponse("The requested resource could not be found.");
    }

    @ExceptionHandler(value={ApolloErrorException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @NotNull
    public ValidationErrors handleApolloErrorException(@NotNull ApolloErrorException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ValidationErrors(e.getErrors());
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

