/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.item.model;

import de.justsoftware.permission.business.item.model.ItemType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Schema(type="String")
public final class ItemId {
    public static final char SEPARATOR = ',';
    private final String _id;
    private final ItemType _type;
    private final String _plainId;

    private ItemId(String id, ItemType type, String plainId) {
        this._id = id;
        this._type = type;
        this._plainId = plainId;
    }

    public static ItemId valueOf(String id) {
        String trimmedId = StringUtils.trimToNull((String)id);
        if (StringUtils.isBlank((CharSequence)trimmedId)) {
            throw new IllegalArgumentException("empty string supplied for nonnull method");
        }
        int comma = trimmedId.indexOf(44);
        switch (comma) {
            case 0: {
                throw new IllegalArgumentException("item id without type");
            }
            case -1: {
                throw new IllegalArgumentException("item id without comma");
            }
        }
        ItemType type = ItemType.get((String)trimmedId.substring(0, comma));
        String plainId = trimmedId.substring(comma + 1);
        if (StringUtils.isBlank((CharSequence)plainId)) {
            throw new IllegalArgumentException("item id with empty id part");
        }
        return new ItemId(trimmedId, type, plainId);
    }

    public ItemType getType() {
        return this._type;
    }

    public String getPlainId() {
        return this._plainId;
    }

    public String asString() {
        return this._id;
    }

    public String toString() {
        return this._id;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() ^ this._id.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass().equals(obj.getClass()) && Objects.equals(this._id, ((ItemId)obj)._id);
    }
}

