/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.csv;

import de.justsoftware.news.domain.csv.CsvExportLanguage;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/news/domain/csv/CsvExportContext;", "", "<init>", "()V", "UTF_8_BOM", "", "dateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "getDateTimeFormatter", "()Ljava/time/format/DateTimeFormatter;", "getYesTranslation", "language", "Lde/justsoftware/news/domain/csv/CsvExportLanguage;", "getNoTranslation", "news-service"})
public final class CsvExportContext {
    @NotNull
    public static final CsvExportContext INSTANCE = new CsvExportContext();
    @NotNull
    public static final String UTF_8_BOM = "\ufeff";
    @NotNull
    private static final DateTimeFormatter dateTimeFormatter;

    private CsvExportContext() {
    }

    @NotNull
    public final DateTimeFormatter getDateTimeFormatter() {
        return dateTimeFormatter;
    }

    @NotNull
    public final String getYesTranslation(@NotNull CsvExportLanguage language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language == CsvExportLanguage.DE ? "ja" : "yes";
    }

    @NotNull
    public final String getNoTranslation(@NotNull CsvExportLanguage language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language == CsvExportLanguage.DE ? "nein" : "no";
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"withZone(...)");
        CsvExportContext.dateTimeFormatter = dateTimeFormatter;
    }
}

