/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.comment;

import de.justsoftware.news.domain.comment.CommentWithTenantId;
import de.justsoftware.news.domain.comment.CountRowMapper;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jdbc.repository.query.Modifying;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004J\\\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H'J(\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00190\u00180\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H'J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH'J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0003H&J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010\n\u001a\u00020\u000bH&J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010\n\u001a\u00020\u000bH&J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$H&J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$H&J$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0$H&J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u0010H'J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010-\u001a\u00020\u0010H'J\u0018\u0010.\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0014H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00060\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/news/domain/comment/PostCommentRepo;", "Lorg/springframework/data/repository/CrudRepository;", "Lde/justsoftware/news/domain/comment/PostComment;", "Lde/justsoftware/news/id/CommentId;", "Lorg/springframework/data/repository/PagingAndSortingRepository;", "insert", "", "id", "postId", "Lde/justsoftware/news/id/PostId;", "parentId", "Lde/justsoftware/news/id/ItemId;", "referenceId", "authorId", "Lde/justsoftware/news/id/ProfileId;", "createdAt", "Ljava/time/Instant;", "updatedAt", "lastUpdatedBy", "jsonContent", "", "text", "countByPostIds", "", "Lkotlin/Pair;", "", "postIds", "getAllWhichHaveAttachments", "Ljava/util/stream/Stream;", "Lde/justsoftware/news/domain/comment/CommentWithTenantId;", "getById", "findAllByParentIdOrderByCreatedAtAsc", "", "findAllByParentIdOrderByCreatedAtDesc", "findAllByParentIdInOrderByCreatedAtAsc", "parentIds", "", "findAllByParentIdInOrderByCreatedAtDesc", "getAllByAuthorIdAndPostIdIn", "markCommentAsDeleted", "", "commentId", "deletedBy", "deletedAt", "getMarkedAsDeleted", "timeToDelete", "updateSourceLanguage", "sourceLanguage", "news-service"})
public interface PostCommentRepo
extends CrudRepository<PostComment, CommentId>,
PagingAndSortingRepository<PostComment, CommentId> {
    @Modifying
    @Query(value="\n        INSERT INTO post_comment (id, post_id, parent_id, reference_id, author_id, created_at, updated_at, last_updated_by, json_content, text)\n        VALUES(:id, :postId, :parentId, :referenceId, :authorId, :createdAt, :updatedAt, :lastUpdatedBy, :jsonContent, :text)\n        ")
    public void insert(@NotNull CommentId var1, @NotNull PostId var2, @NotNull ItemId var3, @NotNull ItemId var4, @NotNull ProfileId var5, @NotNull Instant var6, @NotNull Instant var7, @NotNull ProfileId var8, @Nullable String var9, @Nullable String var10);

    @Query(value="\n        SELECT post_id as postId, COUNT(*) as count FROM post_comment\n        WHERE post_id in (:postIds)\n        AND deleted = false\n        GROUP BY post_id\n        ", rowMapperClass=CountRowMapper.class)
    @NotNull
    public Set<Pair<PostId, Integer>> countByPostIds(@NotNull Set<PostId> var1);

    @Query(value="\n        select \n            distinct post_comment.id,\n            post_comment.post_id, \n            post_comment.author_id,\n            post_comment.text,\n            channel.tenant_id \n        from post_comment\n        inner join attachment on post_comment.id = attachment.item_id\n        left join post on post_comment.post_id = post.id \n        left join channel on post.channel_id = channel.id\n    ")
    @NotNull
    public Stream<CommentWithTenantId> getAllWhichHaveAttachments();

    @NotNull
    public PostComment getById(@NotNull CommentId var1);

    @NotNull
    public List<PostComment> findAllByParentIdOrderByCreatedAtAsc(@NotNull ItemId var1);

    @NotNull
    public List<PostComment> findAllByParentIdOrderByCreatedAtDesc(@NotNull ItemId var1);

    @NotNull
    public List<PostComment> findAllByParentIdInOrderByCreatedAtAsc(@NotNull Collection<? extends ItemId> var1);

    @NotNull
    public List<PostComment> findAllByParentIdInOrderByCreatedAtDesc(@NotNull Collection<? extends ItemId> var1);

    @NotNull
    public Set<PostComment> getAllByAuthorIdAndPostIdIn(@NotNull ProfileId var1, @NotNull Collection<PostId> var2);

    @Modifying
    @Query(value="\n        UPDATE post_comment\n        SET deleted = '1', deleted_by = :deletedBy, deleted_at = :deletedAt\n        WHERE id = :commentId\n        ")
    public boolean markCommentAsDeleted(@NotNull CommentId var1, @NotNull ProfileId var2, @NotNull Instant var3);

    @Query(value="Select id FROM post_comment WHERE deleted = '1' AND deleted_at < :timeToDelete")
    @NotNull
    public Set<CommentId> getMarkedAsDeleted(@NotNull Instant var1);

    @Modifying
    @Query(value="UPDATE post_comment SET source_language = :sourceLanguage WHERE id = :id")
    public void updateSourceLanguage(@NotNull CommentId var1, @NotNull String var2);
}

