/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.toro.service;

import de.justsoftware.mobile.gateway.app.model.remote.ApiApp;
import de.justsoftware.mobile.gateway.toro.model.local.TranslationLanguage;
import de.justsoftware.mobile.gateway.toro.model.remote.ApiMobileAppsInfo;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0012R\u0010\u0010\u0002\u001a\u00020\u00038\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "", "toroBaseUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "availableAppsUri", "Ljava/net/URI;", "homeScreenAppIdsUri", "mobileAppsInfoUri", "getAvailableApps", "", "Lde/justsoftware/mobile/gateway/app/model/remote/ApiApp;", "getHomeScreenAppIds", "", "getMobileAppsInfo", "Lde/justsoftware/mobile/gateway/toro/model/remote/ApiMobileAppsInfo;", "updateTranslationLanguage", "", "profileId", "translationLanguage", "Lde/justsoftware/mobile/gateway/toro/model/local/TranslationLanguage;", "updateTranslationLanguageUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nToroApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToroApiGatewayService.kt\nde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n52#2:60\n52#2:61\n52#2:69\n86#2:70\n2851#3,7:62\n1#4:71\n*S KotlinDebug\n*F\n+ 1 ToroApiGatewayService.kt\nde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService\n*L\n26#1:60\n30#1:61\n35#1:69\n41#1:70\n31#1:62,7\n*E\n"})
public class ToroApiGatewayService {
    @Value(value="${just.toro.baseUrl}")
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI availableAppsUri;
    @NotNull
    private final URI homeScreenAppIdsUri;
    @NotNull
    private final URI mobileAppsInfoUri;

    public ToroApiGatewayService(@Value(value="${just.toro.baseUrl}") @NotNull String toroBaseUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.toroBaseUrl = toroBaseUrl;
        this.webClient = webClient;
        this.availableAppsUri = UrisKt.buildUri$default((String)(this.toroBaseUrl + "/context/api/v1/appConfig/availableApps?client=MOBILE"), null, null, (int)6, null);
        this.homeScreenAppIdsUri = UrisKt.buildUri$default((String)(this.toroBaseUrl + "/context/api/v1/homeScreen/homeScreenApps?client=MOBILE"), null, null, (int)6, null);
        this.mobileAppsInfoUri = UrisKt.buildUri$default((String)(this.toroBaseUrl + "/api/v1/mobileapps/info"), null, null, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ApiApp> getAvailableApps() {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.availableAppsUri;
        boolean $i$f$get = false;
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getHomeScreenAppIds() {
        Object v0;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.homeScreenAppIdsUri;
        boolean $i$f$get = false;
        Iterable $this$reduceOrNull$iv = (Iterable)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void ids;
                List list = (List)iterator$iv.next();
                List acc = (List)accumulator$iv;
                boolean bl = false;
                accumulator$iv = CollectionsKt.plus((Collection)acc, (Iterable)((Iterable)ids));
            }
            v0 = accumulator$iv;
        }
        List list = v0;
        Set set = list != null ? CollectionsKt.toSet((Iterable)list) : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiMobileAppsInfo getMobileAppsInfo() {
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uri$iv = this.mobileAppsInfoUri;
        boolean $i$f$get = false;
        return (ApiMobileAppsInfo)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void updateTranslationLanguage(@NotNull String profileId, @Nullable TranslationLanguage translationLanguage) {
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uRI = this.updateTranslationLanguageUri(profileId, translationLanguage);
        boolean $i$f$put = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private URI updateTranslationLanguageUri(String profileId, TranslationLanguage translationLanguage) {
        Map map;
        Map map2;
        if (translationLanguage != null) {
            TranslationLanguage translationLanguage2 = translationLanguage;
            boolean bl = false;
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"translationLanguage", (Object)translationLanguage2));
        } else {
            map2 = map = null;
        }
        if (map2 == null) {
            map = MapsKt.emptyMap();
        }
        Map params = map;
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/api/v1/person/" + profileId + "/translationLanguage"), (Map)params, null, (int)4, null);
    }
}

