/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.profile;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.ScimException;
import de.justsoftware.justimport.business.model.ScimImportedAttributes;
import de.justsoftware.justimport.kafka.ScimImportedAttributesProducer;
import de.justsoftware.justimport.kafka.model.KafkaFieldMapping;
import de.justsoftware.justimport.persistence.ScimProfileFieldMappingRepository;
import de.justsoftware.justimport.persistence.ScimUserResourceRepository;
import de.justsoftware.justimport.persistence.model.DbScimProfileFieldMapping;
import de.justsoftware.justimport.persistence.model.DbScimUserResource;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ScimFieldMappingService {
    private static final Logger LOG = LoggerFactory.getLogger(ScimFieldMappingService.class);
    private static final int IMPORT_USER_PAGE_SIZE = 100;
    private final ScimImportedAttributesProducer _userPublisher;
    private final ScimProfileFieldMappingRepository _profileFieldMappingRepository;
    private final ScimUserResourceRepository _scimUserResourceRepository;

    @Autowired
    public ScimFieldMappingService(ScimImportedAttributesProducer importedAttributesProducer, ScimProfileFieldMappingRepository profileFieldMappingRepository, ScimUserResourceRepository scimUserResourceRepository) {
        this._userPublisher = importedAttributesProducer;
        this._profileFieldMappingRepository = profileFieldMappingRepository;
        this._scimUserResourceRepository = scimUserResourceRepository;
    }

    public boolean saveNewFieldMapping(KafkaFieldMapping fieldMapping) {
        boolean isLatestVersion;
        Optional latestInDb = this._profileFieldMappingRepository.findLatestForTenant(fieldMapping.tenantId());
        boolean bl = isLatestVersion = latestInDb.isEmpty() || fieldMapping.version() > ((DbScimProfileFieldMapping)latestInDb.get()).getVersion();
        if (isLatestVersion) {
            this._profileFieldMappingRepository.saveAndFlush((Object)fieldMapping.toDbEntity());
        }
        return isLatestVersion;
    }

    public void importProfileAttributes(KafkaFieldMapping fieldMapping) {
        Page currentPage;
        PageRequest pageable = PageRequest.of((int)0, (int)100);
        do {
            currentPage = this._scimUserResourceRepository.allByTenantId(fieldMapping.tenantId(), (Pageable)pageable);
            currentPage.forEach(resource -> this.importProfileAttributes(resource, fieldMapping));
            pageable = pageable.next();
        } while (currentPage.hasNext());
    }

    public void importProfileAttributes(DbScimUserResource resource) {
        this._profileFieldMappingRepository.findLatestForTenant(resource.getTenantId()).ifPresent(mapping -> this.importProfileAttributes(resource, mapping.toKafkaRecord()));
    }

    private void importProfileAttributes(DbScimUserResource resource, KafkaFieldMapping fieldMapping) {
        HashMap importedAttributes = new HashMap();
        fieldMapping.mapping().entries().forEach(entry -> {
            try {
                Path path = Path.fromString((String)((String)entry.getKey()));
                JsonNode value = resource.getData().asGenericScimResource().getValue(path);
                if (value instanceof TextNode) {
                    String textValue = value.textValue();
                    importedAttributes.put((String)entry.getValue(), "JUST_SOCIAL_DELETE_ATTRIBUTE".equals(textValue) ? null : textValue);
                    return;
                }
                if (value == null || value instanceof NullNode) {
                    importedAttributes.put((String)entry.getValue(), null);
                    LOG.debug("No matching attribute for filter {} on userResource with id {}", entry.getKey(), (Object)resource.getProfileId());
                } else {
                    LOG.warn("No NullNode or TextNode was returned for filter {} on userResource with id {}. Scim Attribute config is probably invalid.", entry.getKey(), (Object)resource.getProfileId());
                }
            }
            catch (ScimException e) {
                LOG.error(String.format("Error retrieving string value for path %s.", entry.getKey()), (Throwable)e);
            }
        });
        this._userPublisher.publishImportedAttributes(resource.getProfileId(), new ScimImportedAttributes(fieldMapping.version(), (UUID)fieldMapping.tenantId().getId(), importedAttributes));
    }
}

