/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.tracking;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.tracking.TrackingService;
import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TrackingService {
    public static final String TRACKING_TOPIC = "tracking";
    private static final Pattern IP4_PATTERN = Pattern.compile("^(\\d+\\.){3}", 2);
    private static final Pattern IP6_PATTERN = Pattern.compile("^(?:[0-9a-f]*:){4}", 2);
    private static final Logger LOG = LoggerFactory.getLogger(TrackingService.class);
    private final KafkaTemplate<String, String> _kafkaTemplate;
    private final ObjectMapper _objectMapper;
    private final Clock _clock;

    public TrackingService(KafkaTemplate<String, String> kafkaTemplate, ObjectMapper objectMapper, Clock clock) {
        this._kafkaTemplate = kafkaTemplate;
        this._objectMapper = objectMapper;
        this._clock = clock;
    }

    public void track(String trackingObject, TenantId tenantId, HttpHeaders headers, ServerHttpRequest request) {
        String uaString = headers.getFirst("user-agent");
        String referer = headers.getFirst("referer");
        String remoteIp = this.getIpAdress(request);
        HashMap data = Maps.newHashMap();
        data.put("userAgent", uaString);
        data.put("referer", referer);
        data.put("ipAddress", remoteIp);
        data.put("time", String.valueOf(Instant.now(this._clock).getEpochSecond()));
        data.put("target", this.extractTarget(trackingObject));
        data.put("tenantId", tenantId);
        try {
            String jsonData = this._objectMapper.writeValueAsString((Object)data);
            this._kafkaTemplate.send("tracking", (Object)jsonData);
        }
        catch (JsonProcessingException e) {
            LOG.error("could not send tracking data: {}", (Object)data, (Object)e);
        }
    }

    private @Nullable String getIpAdress(ServerHttpRequest request) {
        return Optional.ofNullable(request.getRemoteAddress()).map(adr -> {
            String ip = adr.getAddress().getHostAddress();
            return TrackingService.anonymizeAddress((String)ip);
        }).orElse(null);
    }

    private @Nullable HashMap<String, String> extractTarget(String trackingObject) {
        try {
            1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
            return (HashMap)this._objectMapper.readValue(trackingObject, (TypeReference)typeRef);
        }
        catch (JsonProcessingException e) {
            LOG.error("could not parse target object: {}", (Object)trackingObject, (Object)e);
            return null;
        }
    }

    public static @Nullable String anonymizeAddress(@Nullable String ip) {
        if (ip == null) {
            return null;
        }
        Matcher ipMatcher = IP4_PATTERN.matcher(ip);
        if (ipMatcher.find()) {
            return ipMatcher.group(0) + "0";
        }
        ipMatcher = IP6_PATTERN.matcher(ip);
        if (ipMatcher.find()) {
            return ipMatcher.group(0) + ":";
        }
        return null;
    }
}

