/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.domain.login.UserLoginId;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.security.PrincipalId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

/*
 * Exception performing whole class analysis ignored.
 */
public class JustAuthToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private final AbstractAuthenticationToken _wrappedToken;
    private final PrincipalId _principalId;
    private final @Nullable TenantId _tenantId;
    private final @Nullable UserLoginId _userLoginId;
    private final @Nullable String _scope;

    public JustAuthToken(PrincipalId profileId, @Nullable TenantId tenantId, AbstractAuthenticationToken token, @Nullable String scope, @Nullable UserLoginId userLoginId) {
        super(token.getAuthorities());
        this._principalId = profileId;
        this._tenantId = tenantId;
        this._wrappedToken = token;
        this._userLoginId = userLoginId;
        this._scope = scope;
        this.setAuthenticated(true);
    }

    public @Nullable String getClientId() {
        AbstractAuthenticationToken abstractAuthenticationToken = this._wrappedToken;
        if (abstractAuthenticationToken instanceof BearerTokenAuthentication) {
            BearerTokenAuthentication token = (BearerTokenAuthentication)abstractAuthenticationToken;
            return JustAuthToken.getClientIdFromAudience((Map)token.getTokenAttributes());
        }
        abstractAuthenticationToken = this._wrappedToken;
        if (abstractAuthenticationToken instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwt = (JwtAuthenticationToken)abstractAuthenticationToken;
            return JustAuthToken.getClientIdFromAudience((Map)jwt.getTokenAttributes());
        }
        abstractAuthenticationToken = this._wrappedToken;
        if (abstractAuthenticationToken instanceof OAuth2LoginAuthenticationToken) {
            OAuth2LoginAuthenticationToken oauth2Login = (OAuth2LoginAuthenticationToken)abstractAuthenticationToken;
            return oauth2Login.getClientRegistration().getClientId();
        }
        abstractAuthenticationToken = this._wrappedToken;
        if (abstractAuthenticationToken instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)abstractAuthenticationToken;
            return token.getAuthorizedClientRegistrationId();
        }
        return null;
    }

    private static @Nullable String getClientIdFromAudience(Map<String, Object> tokenAttributes) {
        ArrayList list;
        Object aud = tokenAttributes.get("aud");
        if (aud instanceof ArrayList && !(list = (ArrayList)aud).isEmpty()) {
            return list.get(0).toString();
        }
        if (aud instanceof String) {
            String audString = (String)aud;
            return audString;
        }
        return null;
    }

    public Object getCredentials() {
        return this._wrappedToken.getCredentials();
    }

    public Object getPrincipal() {
        return this._wrappedToken.getPrincipal();
    }

    public @Nullable TenantId getTenantId() {
        return this._tenantId;
    }

    public PrincipalId getPrincipalId() {
        return this._principalId;
    }

    public @Nullable UserLoginId getUserLoginId() {
        return this._userLoginId;
    }

    public @Nullable String getScope() {
        return this._scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JustAuthToken)) {
            return false;
        }
        JustAuthToken other = (JustAuthToken)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractAuthenticationToken this$_wrappedToken = this._wrappedToken;
        AbstractAuthenticationToken other$_wrappedToken = other._wrappedToken;
        if (this$_wrappedToken == null ? other$_wrappedToken != null : !this$_wrappedToken.equals(other$_wrappedToken)) {
            return false;
        }
        PrincipalId this$_principalId = this._principalId;
        PrincipalId other$_principalId = other._principalId;
        if (this$_principalId == null ? other$_principalId != null : !this$_principalId.equals(other$_principalId)) {
            return false;
        }
        TenantId this$_tenantId = this._tenantId;
        TenantId other$_tenantId = other._tenantId;
        if (this$_tenantId == null ? other$_tenantId != null : !this$_tenantId.equals(other$_tenantId)) {
            return false;
        }
        UserLoginId this$_userLoginId = this._userLoginId;
        UserLoginId other$_userLoginId = other._userLoginId;
        if (this$_userLoginId == null ? other$_userLoginId != null : !this$_userLoginId.equals(other$_userLoginId)) {
            return false;
        }
        String this$_scope = this._scope;
        String other$_scope = other._scope;
        return !(this$_scope == null ? other$_scope != null : !this$_scope.equals(other$_scope));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JustAuthToken;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AbstractAuthenticationToken $_wrappedToken = this._wrappedToken;
        result = result * 59 + ($_wrappedToken == null ? 43 : $_wrappedToken.hashCode());
        PrincipalId $_principalId = this._principalId;
        result = result * 59 + ($_principalId == null ? 43 : $_principalId.hashCode());
        TenantId $_tenantId = this._tenantId;
        result = result * 59 + ($_tenantId == null ? 43 : $_tenantId.hashCode());
        UserLoginId $_userLoginId = this._userLoginId;
        result = result * 59 + ($_userLoginId == null ? 43 : $_userLoginId.hashCode());
        String $_scope = this._scope;
        result = result * 59 + ($_scope == null ? 43 : $_scope.hashCode());
        return result;
    }
}

