/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.ids;

import com.fasterxml.jackson.annotation.JsonCreator;
import de.justsoftware.gateway.ids.core.AbstractUUIDBasedItemId;
import de.justsoftware.gateway.ids.core.IdParser;
import de.justsoftware.gateway.ids.core.ItemType;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

public class TenantId
extends AbstractUUIDBasedItemId {
    private static final long serialVersionUID = 1L;

    public TenantId(UUID id) {
        super(id, ItemType.TENANT);
    }

    public static TenantId random() {
        return new TenantId(UUID.randomUUID());
    }

    @JsonCreator
    public static TenantId parse(String tenantId) {
        return (TenantId)IdParser.parse((ItemType)ItemType.TENANT, (String)tenantId, s -> new TenantId(UUID.fromString(s)));
    }

    public static @Nullable TenantId parseOrNull(@Nullable String tenantId) {
        if (tenantId == null) {
            return null;
        }
        return (TenantId)IdParser.parse((ItemType)ItemType.TENANT, (String)tenantId, s -> new TenantId(UUID.fromString(s)));
    }
}

