/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.domain.idp;

import de.justsoftware.gateway.domain.idp.JustClientRegistration;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.security.oauth2.ClientTarget;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.StringUtils;

@Table(value="client_registration")
public class JustClientRegistration {
    @Id
    @Column(value="registration_id")
    private String registrationId;
    @Column(value="tenant_id")
    private @Nullable TenantId tenantId;
    @Column(value="client_id")
    private String clientId;
    @Column(value="client_secret")
    private @Nullable String clientSecret;
    @Column(value="client_name")
    private String clientName;
    @Column(value="username_attribute")
    private String userNameAttribute;
    @Column(value="jwk_set_uri")
    private @Nullable String jwkSetUri;
    @Column(value="issuer_uri")
    private @Nullable String issuerUri;
    @Column(value="token_uri")
    private String tokenUri;
    @Column(value="authorization_uri")
    private String authorizationUri;
    @Column(value="authorization_grant_type")
    private String authorizationGrantType;
    @Column(value="targets")
    private @Nullable String targets;
    @Column(value="default_provider")
    private boolean defaultProvider;
    @Column(value="user_info_uri")
    private String userInfoUri;
    @Column(value="scope")
    private String scope;
    @Column(value="redirect_uri")
    private String redirect_uri;
    @Column(value="end_session_endpoint")
    private @Nullable String end_session_endpoint;
    @Column(value="version")
    @Version
    private final long version;

    public ClientRegistration toClientRegistration() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("tenantId", this.tenantId != null ? this.tenantId.asString() : null);
        metadata.put("targets", StringUtils.commaDelimitedListToSet((String)this.targets).stream().map(ClientTarget::valueOf).collect(Collectors.toUnmodifiableSet()));
        metadata.put("defaultProvider", this.defaultProvider);
        metadata.put("end_session_endpoint", this.end_session_endpoint);
        if (this.version > 0L) {
            metadata.put("version", this.version);
        }
        return ClientRegistration.withRegistrationId((String)this.registrationId).clientId(this.clientId).clientSecret(this.clientSecret).clientName(this.clientName).tokenUri(this.tokenUri).issuerUri(this.issuerUri).authorizationUri(this.authorizationUri).userInfoUri(this.userInfoUri).userNameAttributeName(this.userNameAttribute).jwkSetUri(this.jwkSetUri).scope((Collection)StringUtils.commaDelimitedListToSet((String)this.scope)).authorizationGrantType(new AuthorizationGrantType(this.authorizationGrantType)).providerConfigurationMetadata(metadata).redirectUri(this.redirect_uri).build();
    }

    public static JustClientRegistration fromClientRegistration(ClientRegistration client) {
        Map metadata = client.getProviderDetails().getConfigurationMetadata();
        Long version = (Long)metadata.get("version");
        if (version == null) {
            version = 0L;
        }
        TenantId tenantId = TenantId.parseOrNull((String)((String)metadata.get("tenantId")));
        return new JustClientRegistrationBuilder().registrationId(client.getRegistrationId()).clientId(client.getClientId()).clientSecret(client.getClientSecret()).clientName(client.getClientName()).issuerUri(client.getProviderDetails().getIssuerUri()).tokenUri(client.getProviderDetails().getTokenUri()).authorizationUri(client.getProviderDetails().getAuthorizationUri()).userInfoUri(client.getProviderDetails().getUserInfoEndpoint().getUri()).userNameAttribute(client.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName()).jwkSetUri(client.getProviderDetails().getJwkSetUri()).scope(StringUtils.collectionToCommaDelimitedString((Collection)client.getScopes())).authorizationGrantType(client.getAuthorizationGrantType().getValue()).tenantId(tenantId).targets(StringUtils.collectionToCommaDelimitedString((Collection)((Collection)metadata.get("targets")))).defaultProvider(metadata.getOrDefault("defaultProvider", false).booleanValue()).end_session_endpoint((String)metadata.get("end_session_endpoint")).version(version.longValue()).redirect_uri(client.getRedirectUri()).build();
    }

    public JustClientRegistration updateFrom(ClientRegistration client) {
        if (!this.registrationId.equals(client.getRegistrationId())) {
            throw new IllegalArgumentException();
        }
        Map metadata = client.getProviderDetails().getConfigurationMetadata();
        return this.toBuilder().clientId(client.getClientId()).clientSecret(client.getClientSecret()).clientName(client.getClientName()).issuerUri(client.getProviderDetails().getIssuerUri()).tokenUri(client.getProviderDetails().getTokenUri()).authorizationUri(client.getProviderDetails().getAuthorizationUri()).userInfoUri(client.getProviderDetails().getUserInfoEndpoint().getUri()).userNameAttribute(client.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName()).jwkSetUri(client.getProviderDetails().getJwkSetUri()).scope(StringUtils.collectionToCommaDelimitedString((Collection)client.getScopes())).authorizationGrantType(client.getAuthorizationGrantType().getValue()).tenantId(TenantId.parseOrNull((String)((String)metadata.get("tenantId")))).redirect_uri(client.getRedirectUri()).targets(StringUtils.collectionToCommaDelimitedString((Collection)((Collection)metadata.get("targets")))).defaultProvider(metadata.getOrDefault("defaultProvider", false).booleanValue()).end_session_endpoint((String)metadata.get("end_session_endpoint")).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull JustClientRegistration.JustClientRegistrationBuilder builder() {
        return new JustClientRegistrationBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull JustClientRegistration.JustClientRegistrationBuilder toBuilder() {
        return new JustClientRegistrationBuilder().registrationId(this.registrationId).tenantId(this.tenantId).clientId(this.clientId).clientSecret(this.clientSecret).clientName(this.clientName).userNameAttribute(this.userNameAttribute).jwkSetUri(this.jwkSetUri).issuerUri(this.issuerUri).tokenUri(this.tokenUri).authorizationUri(this.authorizationUri).authorizationGrantType(this.authorizationGrantType).targets(this.targets).defaultProvider(this.defaultProvider).userInfoUri(this.userInfoUri).scope(this.scope).redirect_uri(this.redirect_uri).end_session_endpoint(this.end_session_endpoint).version(this.version);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRegistrationId() {
        return this.registrationId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @Nullable TenantId getTenantId() {
        return this.tenantId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @Nullable String getClientSecret() {
        return this.clientSecret;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @Nullable String getJwkSetUri() {
        return this.jwkSetUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @Nullable String getIssuerUri() {
        return this.issuerUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTokenUri() {
        return this.tokenUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @Nullable String getTargets() {
        return this.targets;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isDefaultProvider() {
        return this.defaultProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRedirect_uri() {
        return this.redirect_uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @Nullable String getEnd_session_endpoint() {
        return this.end_session_endpoint;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getVersion() {
        return this.version;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRegistrationId(String registrationId) {
        this.registrationId = registrationId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTenantId(@Nullable TenantId tenantId) {
        this.tenantId = tenantId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientSecret(@Nullable String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setJwkSetUri(@Nullable String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setIssuerUri(@Nullable String issuerUri) {
        this.issuerUri = issuerUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAuthorizationGrantType(String authorizationGrantType) {
        this.authorizationGrantType = authorizationGrantType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTargets(@Nullable String targets) {
        this.targets = targets;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDefaultProvider(boolean defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setScope(String scope) {
        this.scope = scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setRedirect_uri(String redirect_uri) {
        this.redirect_uri = redirect_uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEnd_session_endpoint(@Nullable String end_session_endpoint) {
        this.end_session_endpoint = end_session_endpoint;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JustClientRegistration)) {
            return false;
        }
        JustClientRegistration other = (JustClientRegistration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDefaultProvider() != other.isDefaultProvider()) {
            return false;
        }
        String this$registrationId = this.getRegistrationId();
        String other$registrationId = other.getRegistrationId();
        if (this$registrationId == null ? other$registrationId != null : !this$registrationId.equals(other$registrationId)) {
            return false;
        }
        TenantId this$tenantId = this.getTenantId();
        TenantId other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$userNameAttribute = this.getUserNameAttribute();
        String other$userNameAttribute = other.getUserNameAttribute();
        if (this$userNameAttribute == null ? other$userNameAttribute != null : !this$userNameAttribute.equals(other$userNameAttribute)) {
            return false;
        }
        String this$jwkSetUri = this.getJwkSetUri();
        String other$jwkSetUri = other.getJwkSetUri();
        if (this$jwkSetUri == null ? other$jwkSetUri != null : !this$jwkSetUri.equals(other$jwkSetUri)) {
            return false;
        }
        String this$issuerUri = this.getIssuerUri();
        String other$issuerUri = other.getIssuerUri();
        if (this$issuerUri == null ? other$issuerUri != null : !this$issuerUri.equals(other$issuerUri)) {
            return false;
        }
        String this$tokenUri = this.getTokenUri();
        String other$tokenUri = other.getTokenUri();
        if (this$tokenUri == null ? other$tokenUri != null : !this$tokenUri.equals(other$tokenUri)) {
            return false;
        }
        String this$authorizationUri = this.getAuthorizationUri();
        String other$authorizationUri = other.getAuthorizationUri();
        if (this$authorizationUri == null ? other$authorizationUri != null : !this$authorizationUri.equals(other$authorizationUri)) {
            return false;
        }
        String this$authorizationGrantType = this.getAuthorizationGrantType();
        String other$authorizationGrantType = other.getAuthorizationGrantType();
        if (this$authorizationGrantType == null ? other$authorizationGrantType != null : !this$authorizationGrantType.equals(other$authorizationGrantType)) {
            return false;
        }
        String this$targets = this.getTargets();
        String other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !this$targets.equals(other$targets)) {
            return false;
        }
        String this$userInfoUri = this.getUserInfoUri();
        String other$userInfoUri = other.getUserInfoUri();
        if (this$userInfoUri == null ? other$userInfoUri != null : !this$userInfoUri.equals(other$userInfoUri)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$redirect_uri = this.getRedirect_uri();
        String other$redirect_uri = other.getRedirect_uri();
        if (this$redirect_uri == null ? other$redirect_uri != null : !this$redirect_uri.equals(other$redirect_uri)) {
            return false;
        }
        String this$end_session_endpoint = this.getEnd_session_endpoint();
        String other$end_session_endpoint = other.getEnd_session_endpoint();
        return !(this$end_session_endpoint == null ? other$end_session_endpoint != null : !this$end_session_endpoint.equals(other$end_session_endpoint));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JustClientRegistration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDefaultProvider() ? 79 : 97);
        String $registrationId = this.getRegistrationId();
        result = result * 59 + ($registrationId == null ? 43 : $registrationId.hashCode());
        TenantId $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $userNameAttribute = this.getUserNameAttribute();
        result = result * 59 + ($userNameAttribute == null ? 43 : $userNameAttribute.hashCode());
        String $jwkSetUri = this.getJwkSetUri();
        result = result * 59 + ($jwkSetUri == null ? 43 : $jwkSetUri.hashCode());
        String $issuerUri = this.getIssuerUri();
        result = result * 59 + ($issuerUri == null ? 43 : $issuerUri.hashCode());
        String $tokenUri = this.getTokenUri();
        result = result * 59 + ($tokenUri == null ? 43 : $tokenUri.hashCode());
        String $authorizationUri = this.getAuthorizationUri();
        result = result * 59 + ($authorizationUri == null ? 43 : $authorizationUri.hashCode());
        String $authorizationGrantType = this.getAuthorizationGrantType();
        result = result * 59 + ($authorizationGrantType == null ? 43 : $authorizationGrantType.hashCode());
        String $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : $targets.hashCode());
        String $userInfoUri = this.getUserInfoUri();
        result = result * 59 + ($userInfoUri == null ? 43 : $userInfoUri.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $redirect_uri = this.getRedirect_uri();
        result = result * 59 + ($redirect_uri == null ? 43 : $redirect_uri.hashCode());
        String $end_session_endpoint = this.getEnd_session_endpoint();
        result = result * 59 + ($end_session_endpoint == null ? 43 : $end_session_endpoint.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NonNull String toString() {
        return "JustClientRegistration(registrationId=" + this.getRegistrationId() + ", tenantId=" + String.valueOf(this.getTenantId()) + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", clientName=" + this.getClientName() + ", userNameAttribute=" + this.getUserNameAttribute() + ", jwkSetUri=" + this.getJwkSetUri() + ", issuerUri=" + this.getIssuerUri() + ", tokenUri=" + this.getTokenUri() + ", authorizationUri=" + this.getAuthorizationUri() + ", authorizationGrantType=" + this.getAuthorizationGrantType() + ", targets=" + this.getTargets() + ", defaultProvider=" + this.isDefaultProvider() + ", userInfoUri=" + this.getUserInfoUri() + ", scope=" + this.getScope() + ", redirect_uri=" + this.getRedirect_uri() + ", end_session_endpoint=" + this.getEnd_session_endpoint() + ", version=" + this.getVersion() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JustClientRegistration(String registrationId, @Nullable TenantId tenantId, String clientId, @Nullable String clientSecret, String clientName, String userNameAttribute, @Nullable String jwkSetUri, @Nullable String issuerUri, String tokenUri, String authorizationUri, String authorizationGrantType, @Nullable String targets, boolean defaultProvider, String userInfoUri, String scope, String redirect_uri, @Nullable String end_session_endpoint, long version) {
        this.registrationId = registrationId;
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientName = clientName;
        this.userNameAttribute = userNameAttribute;
        this.jwkSetUri = jwkSetUri;
        this.issuerUri = issuerUri;
        this.tokenUri = tokenUri;
        this.authorizationUri = authorizationUri;
        this.authorizationGrantType = authorizationGrantType;
        this.targets = targets;
        this.defaultProvider = defaultProvider;
        this.userInfoUri = userInfoUri;
        this.scope = scope;
        this.redirect_uri = redirect_uri;
        this.end_session_endpoint = end_session_endpoint;
        this.version = version;
    }
}

