/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.config;

import de.justsoftware.gateway.domain.login.UserLoginId;
import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.ids.core.AbstractId;
import de.justsoftware.gateway.ids.core.AbstractItemId;
import de.justsoftware.gateway.ids.core.AbstractUUIDBasedId;
import de.justsoftware.gateway.ids.core.AbstractUUIDBasedItemId;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.r2dbc.convert.R2dbcCustomConversions;
import org.springframework.data.r2dbc.dialect.OracleDialect;
import org.springframework.data.r2dbc.dialect.PostgresDialect;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;

@Configuration
public class DatabaseConfig {
    private final R2dbcDialect _databaseDialect;

    public DatabaseConfig(@Value(value="${spring.r2dbc.url}") String r2dbcString) {
        this._databaseDialect = this.getDialect(r2dbcString);
    }

    @Bean
    public R2dbcCustomConversions customConversions() {
        if (this._databaseDialect.equals(OracleDialect.INSTANCE)) {
            return this.getOracleConversions();
        }
        return this.getPostgresConversions();
    }

    private R2dbcCustomConversions getPostgresConversions() {
        Set userLoginIdConverters = ConverterBuilder.reading(UUID.class, UserLoginId.class, UserLoginId::new).andWriting(AbstractId::getId).getConverters();
        Set tenantIdConverters = ConverterBuilder.reading(UUID.class, TenantId.class, TenantId::new).andWriting(AbstractItemId::getId).getConverters();
        Set profileIdConverters = ConverterBuilder.reading(Long.class, ProfileId.class, ProfileId::new).andWriting(AbstractItemId::getId).getConverters();
        ArrayList converters = new ArrayList();
        converters.addAll(profileIdConverters);
        converters.addAll(userLoginIdConverters);
        converters.addAll(tenantIdConverters);
        return R2dbcCustomConversions.of((R2dbcDialect)PostgresDialect.INSTANCE, converters);
    }

    private R2dbcCustomConversions getOracleConversions() {
        Set userLoginIdConverters = ConverterBuilder.reading(byte[].class, UserLoginId.class, bytes -> new UserLoginId(this.parseUUIDFromByteArray(bytes))).andWriting(AbstractUUIDBasedId::toByteArray).getConverters();
        Set tenantIdConverters = ConverterBuilder.reading(byte[].class, TenantId.class, bytes -> new TenantId(this.parseUUIDFromByteArray(bytes))).andWriting(AbstractUUIDBasedItemId::toByteArray).getConverters();
        Set profileIdConverters = ConverterBuilder.reading(BigDecimal.class, ProfileId.class, bd -> new ProfileId(bd.longValue())).andWriting(id -> new BigDecimal((Long)id.getId())).getConverters();
        ArrayList converters = new ArrayList();
        converters.addAll(profileIdConverters);
        converters.addAll(userLoginIdConverters);
        converters.addAll(tenantIdConverters);
        return R2dbcCustomConversions.of((R2dbcDialect)OracleDialect.INSTANCE, converters);
    }

    private UUID parseUUIDFromByteArray(byte[] obj) {
        ByteBuffer buffer = ByteBuffer.wrap(obj);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    private R2dbcDialect getDialect(String r2dbcString) {
        if (r2dbcString.contains("oracle")) {
            return OracleDialect.INSTANCE;
        }
        return PostgresDialect.INSTANCE;
    }
}

