/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.filter;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.stereotype.Component;

@Component
public class RouteLoggingGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RouteLoggingGatewayFilterFactory.class);

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            Set uris = (Set)exchange.getAttributeOrDefault(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR, Collections.emptySet());
            String originalUri = uris.isEmpty() ? exchange.getRequest().getPath().value() : ((URI)uris.iterator().next()).toString();
            Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
            URI routeUri = (URI)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
            if (route != null) {
                LOG.info("Incoming request " + originalUri + " is routed to id: " + route.getId() + ", uri:" + String.valueOf(routeUri));
            } else {
                LOG.warn("No route for request " + originalUri);
            }
            return chain.filter(exchange);
        };
    }
}

