/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.internal.controllers;

import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.settings.model.SettingsBO;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"}, produces={"application/json"})
@Schema(description="DriveInternal")
@ParametersAreNonnullByDefault
public class InternalSettingsController {
    private final SettingsService _settingsService;

    @Autowired
    public InternalSettingsController(SettingsService settingsService) {
        this._settingsService = settingsService;
    }

    @RequestMapping(path={"/settings/publicLinks/{enabled}"}, method={RequestMethod.PATCH})
    public SettingsBO setPublicLinksEnabled(AuthorizationContext authContext, @PathVariable boolean enabled) {
        authContext.checkTenantManager();
        return this._settingsService.insertPublicLinksSettings(authContext.getNonnullTenantId(), enabled);
    }

    @RequestMapping(path={"/settings/antivirus/{enabled}"}, method={RequestMethod.PATCH})
    public SettingsBO setAntivirusEnabled(AuthorizationContext authContext, @PathVariable boolean enabled) {
        authContext.checkTenantManager();
        return this._settingsService.insertAntivirusSettings(authContext.getNonnullTenantId(), enabled);
    }

    @RequestMapping(path={"/settings"}, method={RequestMethod.GET})
    public SettingsBO getSettings(AuthorizationContext authContext) {
        authContext.checkTenantManager();
        return this._settingsService.getSettings(authContext.getNonnullTenantId());
    }
}

