/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.business.search.IndexRequirementsCollector;
import de.justsoftware.drive.business.search.SearchIndexPublisher;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.search.shared.model.SolrIndexType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
@SuppressFBWarnings(value={"MS_EXPOSE_REP"}, justification="we never call SearchIndexFieldGroup.values()")
public enum SearchIndexFieldGroup {
    DOCUMENT_VERSION/* Unavailable Anonymous Inner Class!! */,
    DOCUMENT/* Unavailable Anonymous Inner Class!! */,
    ITEM/* Unavailable Anonymous Inner Class!! */,
    FIRST_PUBLIC_CHANGE/* Unavailable Anonymous Inner Class!! */,
    VISIBILITIES/* Unavailable Anonymous Inner Class!! */,
    CONTENT/* Unavailable Anonymous Inner Class!! */;

    private static final ImmutableSetMultimap<SolrIndexType, SearchIndexFieldGroup> FIELD_GROUPS_PER_TYPE;

    public void publish(DocumentVersionBO documentVersion, SearchIndexPublisher publisher) {
    }

    public void requirements(DocumentVersionBO documentVersion, IndexRequirementsCollector collector) {
    }

    @Nonnull
    public static ImmutableSet<SearchIndexFieldGroup> forIndexType(SolrIndexType type) {
        return FIELD_GROUPS_PER_TYPE.get((Object)type);
    }

    @Nonnull
    public static ImmutableSet<SearchIndexFieldGroup> forIndexType(Iterable<SolrIndexType> indexTypes) {
        return FluentIterable.from(indexTypes).transformAndConcat(SearchIndexFieldGroup::forIndexType).toSet();
    }

    @CheckForNull
    private static String formatDate(@Nullable Instant instant) {
        if (instant == null) {
            return null;
        }
        return DateTimeFormatter.ISO_INSTANT.format(instant);
    }

    static {
        FIELD_GROUPS_PER_TYPE = ImmutableSetMultimap.builder().putAll((Object)SolrIndexType.FULL, (Object[])SearchIndexFieldGroup.values()).putAll((Object)SolrIndexType.REINDEX, (Object[])SearchIndexFieldGroup.values()).putAll((Object)SolrIndexType.METADATA, (Object[])new SearchIndexFieldGroup[]{DOCUMENT_VERSION, DOCUMENT, ITEM, FIRST_PUBLIC_CHANGE, VISIBILITIES}).build();
    }
}

