/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.drive.business.kafka.VirusScanKafkaDto;
import de.justsoftware.drive.common.file.model.StorageId;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class VirusScanKafkaProducer {
    public static final String JUST_VIRUS_SCAN_TOPIC = "just.virus.scan";
    private static final Logger LOG = LoggerFactory.getLogger(VirusScanKafkaProducer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @CheckForNull
    private final Producer<String, String> _producer;

    @Autowired
    public VirusScanKafkaProducer(@Nullable Producer<String, String> producer) {
        this._producer = producer;
    }

    public void publish(StorageId key, VirusScanKafkaDto data) {
        if (this._producer != null) {
            try {
                this._producer.send(new ProducerRecord(JUST_VIRUS_SCAN_TOPIC, (Object)key.toString(), (Object)OBJECT_MAPPER.writeValueAsString((Object)data)));
            }
            catch (JsonProcessingException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

