/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.change.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.drive.business.change.HistoryCompactorService;
import de.justsoftware.drive.business.document.ItemLockService;
import de.justsoftware.drive.business.file.FileStorageService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.persistence.change.ChangeCreateModel;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import de.justsoftware.drive.persistence.file.DocumentSupportDAO;
import de.justsoftware.drive.persistence.folder.FolderVersionCreateModel;
import de.justsoftware.drive.persistence.folder.FolderVersionDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.time.Clock;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class HistoryCompactorServiceImpl
implements HistoryCompactorService {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryCompactorServiceImpl.class);
    private static final int SLOW_ITEM_THRESHOLD_IN_S = 5;
    private final ItemDAO _itemDAO;
    private final ChangeDAO _changeDAO;
    private final FolderVersionDAO _folderVersionDAO;
    private final SubFolderDAO _subFolderDAO;
    private final DocumentSupportDAO _documentSupportDAO;
    private final DocumentVersionDAO _documentVersionDAO;
    private final DocumentDAO _documentDAO;
    private final FileStorageService _fileStorageService;
    private final TransactionSupport _transactionSupport;
    private final ItemLockService _itemLockService;
    private final Clock _clock;

    @Autowired
    public HistoryCompactorServiceImpl(ItemDAO itemDAO, ChangeDAO changeDAO, FolderVersionDAO folderVersionDAO, SubFolderDAO subFolderDAO, DocumentSupportDAO documentService, DocumentVersionDAO documentVersionDAO, DocumentDAO documentDAO, FileStorageService fileStorageService, TransactionSupport transactionSupport, ItemLockService itemLockService, Clock clock) {
        this._itemDAO = itemDAO;
        this._changeDAO = changeDAO;
        this._folderVersionDAO = folderVersionDAO;
        this._subFolderDAO = subFolderDAO;
        this._documentSupportDAO = documentService;
        this._documentVersionDAO = documentVersionDAO;
        this._documentDAO = documentDAO;
        this._fileStorageService = fileStorageService;
        this._transactionSupport = transactionSupport;
        this._itemLockService = itemLockService;
        this._clock = clock;
    }

    public void compactAllItems() {
        AtomicInteger itemsWithError = new AtomicInteger();
        AtomicInteger itemsTotal = new AtomicInteger();
        HashMap slowItems = new HashMap();
        Stopwatch totalDuration = Stopwatch.createStarted();
        Set<ItemType> typesToCompact = Set.of(ItemType.CHAT);
        for (ItemType itemType : typesToCompact) {
            LOG.info("Start compacting all items of type {}.", (Object)itemType);
            Stopwatch itemDuration = Stopwatch.createStarted();
            this._itemDAO.forEachItemOfTypeWithAtLeastNChanges(itemType, 15, itemId -> {
                itemsTotal.incrementAndGet();
                try {
                    this.lockAndProcess(itemId);
                }
                catch (RuntimeException e) {
                    itemsWithError.incrementAndGet();
                    LOG.error("Compressing item '" + String.valueOf(itemId) + "' throw an exception. Continue with next item.", (Throwable)e);
                }
                long itemProcessingTime = itemDuration.elapsed(TimeUnit.SECONDS);
                if (itemProcessingTime >= 5L) {
                    slowItems.put(itemId, itemProcessingTime);
                }
                itemDuration.reset();
            });
        }
        long totalProcessingTime = totalDuration.elapsed(TimeUnit.MINUTES);
        LOG.info("Finished compacting {} items. Took {} minutes. {} caused exceptions.", new Object[]{itemsTotal.get(), totalProcessingTime, itemsWithError.get()});
        if (!slowItems.isEmpty()) {
            LOG.info("{} items took more than {}s.", (Object)slowItems.size(), (Object)5);
            LOG.info("Items (ItemId -> Processing time in s): {}", slowItems);
        }
    }

    @VisibleForTesting
    void lockAndProcess(ItemId itemId) {
        this._itemLockService.acquireAndExecute(itemId, () -> {
            this.process(itemId);
            return this;
        });
    }

    private void process(ItemId itemId) {
        Set<ItemId> itemAsSet = Set.of(itemId);
        ChangeBO latestChange = (ChangeBO)this._changeDAO.getNewestChangePerItem(itemAsSet).get((Object)itemId);
        ChangeBO initialChange = (ChangeBO)this._changeDAO.getInitialChangePerItem(itemAsSet).get((Object)itemId);
        if (latestChange == null || initialChange == null) {
            LOG.error("latestChange or initialChange are null for item '{}'", (Object)itemId.getValue());
            return;
        }
        DocumentVersionId cLatestId = latestChange.getDocumentVersionId();
        DocumentVersionId cInitialId = initialChange.getDocumentVersionId();
        ImmutableList postTransactionActions = (ImmutableList)this._transactionSupport.doInTransaction(() -> {
            ImmutableList.Builder callbacks = ImmutableList.builder();
            DocumentVersionId cNewId = this.createCNew(latestChange);
            this._subFolderDAO.updateParentRelationshipForChange(cLatestId, cNewId);
            Set obsoleteChanges = this.prepareItemForCompaction(cInitialId, cLatestId, cNewId);
            Runnable deleteDocumentsFromStorageServer = this.deleteDocumentsIntroducedInChanges(obsoleteChanges);
            callbacks.add((Object)deleteDocumentsFromStorageServer);
            this.deleteObsoleteSubFolderVersions(cLatestId);
            this.deleteObsoleteChanges(obsoleteChanges);
            this._documentDAO.deleteAllWithoutVersions();
            this._subFolderDAO.insertParentRelationshipForDocumentsInChange(cLatestId);
            this._documentDAO.repairMissingLastVersionLink();
            return callbacks.build();
        });
        postTransactionActions.forEach(Runnable::run);
    }

    @Nonnull
    private void deleteObsoleteChanges(Set<DocumentVersionId> obsoleteChanges) {
        ImmutableSetMultimap.Builder changesPerItem = ImmutableSetMultimap.builder();
        this._documentVersionDAO.getItemIdsOfDocumentVersions(obsoleteChanges).forEach((documentVersionId, item) -> changesPerItem.put(item, documentVersionId));
        this._changeDAO.deleteChanges(obsoleteChanges);
        this._folderVersionDAO.deleteIntroducedByChanges(obsoleteChanges);
        this._documentDAO.unlinkLastVersionUpdatedByChanges(obsoleteChanges);
        this._documentVersionDAO.deleteIntroducedByChanges(obsoleteChanges);
    }

    @Nonnull
    private Set<DocumentVersionId> prepareItemForCompaction(DocumentVersionId cInitialId, DocumentVersionId cLatestId, DocumentVersionId cNewId) {
        ImmutableSet obsoleteChanges;
        Map documentsInCurrentVersion = this._subFolderDAO.getAllDocumentsWithLatestVersionInFolder(cNewId);
        if (!documentsInCurrentVersion.isEmpty()) {
            obsoleteChanges = this._changeDAO.getIntermediateChanges(cInitialId, cLatestId);
            Set setOfLatestVersions = Set.copyOf(documentsInCurrentVersion.values());
            this._documentVersionDAO.moveVersionsToTargetChange(setOfLatestVersions, cNewId);
            this._subFolderDAO.deleteByParentIntroducedInChange((Set)obsoleteChanges);
            this._documentVersionDAO.moveOtherVersionsToTargetChange(documentsInCurrentVersion, cLatestId);
        } else {
            obsoleteChanges = this._changeDAO.getIntermediateChanges(cInitialId, cNewId);
        }
        return obsoleteChanges;
    }

    @Nonnull
    private DocumentVersionId createCNew(ChangeBO lastChange) {
        DocumentVersionId lastChangeId = lastChange.getDocumentVersionId();
        Set<DocumentVersionId> lastChangeAsSet = Collections.singleton(lastChangeId);
        DocumentVersionBO lastRootFolder = (DocumentVersionBO)Preconditions.checkNotNull((Object)((DocumentVersionBO)this._documentSupportDAO.getDocumentVersionsByIds(lastChangeAsSet).get((Object)lastChangeId)));
        FolderVersionBO lastRootFolderBO = (FolderVersionBO)Preconditions.checkNotNull((Object)((FolderVersionBO)this._folderVersionDAO.getFolderVersionsByIds(lastChangeAsSet).get((Object)lastChangeId)));
        FolderVersionCreateModel folderVersion = ((FolderVersionCreateModel)((FolderVersionCreateModel)this._folderVersionDAO.folderVersionCreateModel().newVersionOf(lastRootFolderBO).setOwner(lastRootFolder.getOwner())).setChangeDate(this._clock.instant())).setIsRoot(true);
        this._folderVersionDAO.insertFolderVersions(Set.of(folderVersion));
        ChangeCreateModel change = this._changeDAO.changeCreateModel().newVersionOf(lastChange).setFolderVersion(folderVersion.getId()).setFirstPublishedDate(Instant.now());
        this._changeDAO.insertChanges(Set.of(change));
        return folderVersion.getId();
    }

    private void deleteObsoleteSubFolderVersions(DocumentVersionId cOldId) {
        Set<DocumentVersionId> cOldAsSet = Collections.singleton(cOldId);
        this._documentDAO.unlinkLastVersionUpdatedByChanges(cOldAsSet);
        Set folderVersions = this._folderVersionDAO.getFolderVersionsByChangeIds(cOldAsSet).values().stream().filter(Predicate.not(DocumentVersionBO::isRoot)).map(DocumentVersionBO::getId).collect(Collectors.toUnmodifiableSet());
        this._subFolderDAO.deleteByParentIntroducedInChange(cOldAsSet);
        this._subFolderDAO.deleteByChildIds(folderVersions);
        this._folderVersionDAO.deleteByIds(folderVersions);
    }

    @Nonnull
    private Runnable deleteDocumentsIntroducedInChanges(Set<DocumentVersionId> obsoleteChanges) {
        ImmutableSet deletedDocuments = this._documentVersionDAO.getDocumentsByChangeIds(obsoleteChanges);
        LOG.debug("Number of deleted documents found {}", (Object)deletedDocuments);
        ImmutableCollection deletedFiles = this._documentSupportDAO.deleteFiles((Set)deletedDocuments).values();
        this._documentSupportDAO.deleteFolders((Set)deletedDocuments);
        return () -> this._fileStorageService.deleteFilesWithTransactionLog((Multimap)Multimaps.index((Iterable)deletedFiles, FileVersionBO::getStorageId));
    }
}

