/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.item;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import de.justsoftware.drive.business.authorization.AuthorizationItem;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.model.AbstractId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class DocumentItem<D extends DocumentVersionBO>
extends AuthorizationItem<DocumentId> {
    private final D _curentVersion;

    public DocumentItem(D currentVersion) {
        super((AbstractId)currentVersion.getDocumentId());
        this._curentVersion = currentVersion;
    }

    @Nonnull
    private static <D> D firstNonnull(@Nullable D currentPublic, @Nullable D currentPrivate) {
        return (D)Preconditions.checkNotNull(currentPublic != null ? currentPublic : currentPrivate);
    }

    @Nonnull
    public D getCurrentVersion() {
        return (D)this._curentVersion;
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    @Nonnull
    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("curentVersion", (Object)this._curentVersion);
    }
}

