/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.internal.controllers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.batch.item.ItemPurgeSchedulerService;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.change.HistoryCompactorJobStarter;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.file.TempFileService;
import de.justsoftware.drive.business.search.SolrIndexQueueProducer;
import de.justsoftware.drive.business.shares.SharesPublisher;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.util.EntryStream;
import de.justsoftware.drive.rest.internal.controllers.InternalDocumentController;
import de.justsoftware.drive.rest.internal.models.InternalFileModel;
import de.justsoftware.drive.rest.models.TempFile;
import de.justsoftware.drive.rest.util.MultipartUtil;
import io.micrometer.observation.annotation.Observed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/internal"}, produces={"application/json"})
@Tag(name="Internal Document Controller", description="Service 2 service API to create and load documents")
@ParametersAreNonnullByDefault
@Observed
public class InternalDocumentController {
    static final String API_MAPPING = "/internal";
    private final DocumentTreeModificationService _documentTreeModificationService;
    private final SolrIndexQueueProducer _solrIndexQueueProducer;
    private final TempFileService _tempFileService;
    private final SharesPublisher _sharesPublisher;
    @CheckForNull
    private final HistoryCompactorJobStarter _historyCompactorJobStarter;
    @CheckForNull
    private final ItemPurgeSchedulerService _itemPurgeSchedulerService;

    @Autowired
    public InternalDocumentController(DocumentTreeModificationService documentTreeModificationService, SolrIndexQueueProducer solrIndexQueueProducer, TempFileService tempFileService, SharesPublisher sharesPublisher, @Autowired(required=false) HistoryCompactorJobStarter historyCompactorJobStarter, @Autowired(required=false) ItemPurgeSchedulerService itemPurgeSchedulerService) {
        this._documentTreeModificationService = documentTreeModificationService;
        this._solrIndexQueueProducer = solrIndexQueueProducer;
        this._tempFileService = tempFileService;
        this._sharesPublisher = sharesPublisher;
        this._historyCompactorJobStarter = historyCompactorJobStarter;
        this._itemPurgeSchedulerService = itemPurgeSchedulerService;
    }

    @RequestMapping(value={"/tmp/upload"}, method={RequestMethod.POST}, produces={"application/json"})
    @Operation(description="Upload temporary files")
    @Nonnull
    public List<TempFile> uploadTempFiles(AuthorizationContext authCtx, MultipartFile ... files) {
        Iterable byteSources = Stream.of(files).map(MultipartUtil.MULTIPART_FILE_TO_BYTESOURCE).collect(Collectors.toList());
        ImmutableMap tempFiles = this._tempFileService.addTempFiles(byteSources, authCtx.getPersonId(), authCtx.getNonnullTenantId());
        return (List)EntryStream.from((Map)tempFiles).map((id, byteSource) -> {
            String filename = byteSource.getFilename();
            String mimeType = FileMetaInfoUtil.getMimeTypeFromSource((String)filename, (ByteSource)byteSource.getByteSource());
            return new TempFile(id, filename, mimeType);
        }).collect(ImmutableList.toImmutableList());
    }

    @RequestMapping(value={"/file/{documentId}/delete"}, method={RequestMethod.DELETE})
    @Operation(description="Delete the file with the given documentId in the context of the provided user")
    public void deleteFiles(@PathVariable(value="documentId") DocumentId documentId, AuthorizationContext authCtx) {
        boolean mayDelete = authCtx.may((AbstractId)documentId, StaticAction.DOCUMENT_DELETE);
        boolean mayDeleteOwnDocument = authCtx.may((AbstractId)documentId, StaticAction.DOCUMENT_DELETE_BY_OWNER);
        boolean mayManage = authCtx.may((AbstractId)documentId, StaticAction.SHARE_MANAGE);
        if (!(mayDelete || mayManage || mayDeleteOwnDocument)) {
            throw new PermissionDeniedException("not allowed");
        }
        this._documentTreeModificationService.deleteDocument(documentId, authCtx.getPersonId());
    }

    @Operation(description="Trigger reindex of metadata of all documents in drive for search")
    @RequestMapping(value={"/reindexMetadata"}, method={RequestMethod.POST})
    public void reindexMetadata() {
        this._solrIndexQueueProducer.reindexMetadata();
    }

    @Operation(description="Trigger republishing of all permission to the permission service.")
    @PostMapping(value={"/publishDrivePermissions"})
    public void publishDrivePermissions() {
        this._sharesPublisher.publishAllSharePermissions();
    }

    @Operation(description="Trigger the job to compact the drive history.")
    @PostMapping(value={"/runDriveHistoryCompactionJob"})
    public void runDriveHistoryCompactionJob() {
        if (this._historyCompactorJobStarter != null) {
            this._historyCompactorJobStarter.startNow();
        }
    }

    @Operation(description="Trigger the job to purge deleted items from Drive and other services.")
    @PostMapping(value={"/runItemPurgeJob"})
    public void runItemPurgeJob() {
        if (this._itemPurgeSchedulerService != null) {
            this._itemPurgeSchedulerService.purgeDeletedItemsNow();
        }
    }

    @Operation(description="Dispatch delete request for all preview sources in just-documents.")
    @DeleteMapping(value={"/deletePreviewSources"})
    public void deletePreviewSources() {
        this._tempFileService.deletePreviewSources();
    }

    @Nonnull
    @Operation(description="Get status of drive infos")
    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    public String status() {
        return "{\"status\": \"ok\"}";
    }

    @RequestMapping(value={"/tmp/move"}, method={RequestMethod.POST}, consumes={"application/json"})
    @Operation(description="Attach the files with the given IDs from Drive's temporary storage to an item. When the call returns successfully, the files belong to the given owner")
    @Nonnull
    public ImmutableMap<TempFileId, InternalFileModel> moveTempFilesToItems(@RequestBody TempFileMoveRequest moveRequest, AuthorizationContext authContext) {
        ImmutableMap moveResult = this._tempFileService.moveTempFilesToItem((Set)ImmutableSet.copyOf((Collection)moveRequest._tempFileIds), moveRequest._targetItemId, authContext.getPersonId(), authContext.getNonnullTenantId());
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)moveResult, InternalFileModel::new));
    }
}

