/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanBo;
import de.justsoftware.drive.common.file.model.VirusScanCreateBo;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.RowBounds;

@ParametersAreNonnullByDefault
@Mapper
public interface VirusScanMapper {
    @Insert(value={"INSERT INTO virus_scan_status(storage_id, status, scan_date, create_date)\nVALUES (#{_storageId}, #{_virusScanStatus}, #{_scanDate}, #{_createDate})\nON CONFLICT (storage_id) DO NOTHING;\n"})
    public void insertVirusScan(VirusScanCreateBo var1);

    @Update(value={"    UPDATE virus_scan_status\n    SET status = #{_virusScanStatus}, scan_date = #{_scanDate}\n    WHERE storage_id = #{_storageId}\n"})
    public void setVirusScanResult(VirusScanBo var1);

    @Select(value={"    SELECT storage_id, status, scan_date FROM virus_scan_status\n    WHERE storage_id = #{storageId}\n"})
    @ResultType(value=VirusScanBo.class)
    public VirusScanBo findVirusScanStatus(StorageId var1);

    @Delete(value={"    <script>\n        DELETE FROM virus_scan_status WHERE storage_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)\n    </script>\n"})
    public void deleteVirusScanStatus(@Param(value="ids") Set<StorageId> var1);

    @Select(value={"SELECT storage_id FROM virus_scan_status WHERE status = 'NOT_SCANNED' ORDER BY create_date DESC;\n"})
    @ResultType(value=StorageId.class)
    @Nonnull
    public Set<StorageId> findAllWithStatusNotScannedLatestFirst(RowBounds var1);

    @Select(value={"SELECT COUNT(*) FROM virus_scan_status WHERE status = 'QUEUED';\n"})
    @ResultType(value=Integer.class)
    public int countQueuedVirusScans();
}

