/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.event.DocumentMetadataChangedEvent;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.FileServiceImpl;
import de.justsoftware.drive.business.file.VirusFoundException;
import de.justsoftware.drive.business.file.VirusScanNotCompletedException;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.file.FileDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FileServiceImpl
implements FileService {
    final FileDAO _fileDAO;
    final FileVersionDAO _fileVersionDAO;
    final FileStorageDAO _fileStorageDao;
    final DocumentDAO _documentDAO;
    final EventBus _eventBus;
    final SettingsService _settingsService;
    final ItemReadService _itemReadService;

    @Autowired
    public FileServiceImpl(FileDAO fileDAO, FileVersionDAO fileVersionDAO, DocumentDAO documentDAO, FileStorageDAO fileStorageDAO, EventBus eventBus, SettingsService settingsService, ItemReadService itemReadService) {
        this._fileDAO = fileDAO;
        this._fileVersionDAO = fileVersionDAO;
        this._documentDAO = documentDAO;
        this._fileStorageDao = fileStorageDAO;
        this._eventBus = eventBus;
        this._settingsService = settingsService;
        this._itemReadService = itemReadService;
    }

    public FileVersionBO getLastFileVersion(DocumentId fileId) {
        DocumentVersionId version = (DocumentVersionId)this._documentDAO.getLastVersions((Set)ImmutableSet.of((Object)fileId)).get((Object)fileId);
        if (version == null) {
            return null;
        }
        return (FileVersionBO)this._fileVersionDAO.getByIds((Set)ImmutableSet.of((Object)version)).get((Object)version);
    }

    @Nonnull
    public ByteSource getFileByteSource(FileVersionBO fileVersion, @Nullable TenantId tenantId) throws VirusScanNotCompletedException {
        this.checkVirusScanStatus(fileVersion, tenantId);
        return this._fileStorageDao.load(fileVersion.getStorageId());
    }

    public void checkVirusScanStatus(FileVersionBO fileVersion, @Nullable TenantId tenantId) {
        boolean antivirusEnabled;
        boolean bl = antivirusEnabled = tenantId != null && this._settingsService.isAntivirusEnabled(tenantId);
        if (antivirusEnabled) {
            switch (1.$SwitchMap$de$justsoftware$drive$common$file$model$VirusScanStatus[fileVersion.getVirusScanStatus().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    throw new VirusScanNotCompletedException("Virus scan not yet completed for storageId: " + String.valueOf(fileVersion.getStorageId()));
                }
                case 5: {
                    throw new VirusFoundException(String.valueOf(fileVersion.getStorageId()) + " is infected");
                }
                default: {
                    throw new IllegalArgumentException("Virus scan status not yet implemented: " + String.valueOf(fileVersion.getVirusScanStatus()));
                }
            }
        }
    }

    public String getFileStorageUrl(StorageId storageId) {
        return this._fileStorageDao.getUrl(storageId);
    }

    public ImmutableMap<DocumentVersionId, FileVersionBO> getVersionsByIds(Set<DocumentVersionId> fileIds) {
        return this._fileVersionDAO.getByIds(fileIds);
    }

    public FileVersionBO getSingleVersionById(DocumentVersionId fileVersionId) {
        return (FileVersionBO)this.getVersionsByIds((Set)ImmutableSet.of((Object)fileVersionId)).get((Object)fileVersionId);
    }

    public ImmutableListMultimap<DocumentId, FileVersionBO> getVersionsByDocumentIds(Set<DocumentId> ids) {
        return this._fileVersionDAO.getVersionsByDocumentIds(ids);
    }

    public ImmutableList<FileVersionBO> getLatestVersions(DocumentId id, int limit) {
        return this._fileVersionDAO.getLatestVersions(id, limit);
    }

    public void updateMetadata(DocumentId fileId, String newDesc, String newTags) {
        this._documentDAO.updateMetadata(fileId, newDesc, newTags);
        this._eventBus.post((Object)new DocumentMetadataChangedEvent(fileId));
    }

    public void setVideoTeaser(FileVersionBO fileVersionBO, VideoTeaserId videoTeaserId) {
        this._fileVersionDAO.setVideoTeaser(fileVersionBO.getId(), videoTeaserId);
    }

    public void deleteVideoTeaser(DocumentVersionId versionId) {
        this._fileVersionDAO.deleteVideoTeaser(versionId);
    }

    public List<FileVersionBO> getFileVersionsByStorageId(StorageId id) {
        return this._fileVersionDAO.getFileVersionsByStorageId(id);
    }
}

