/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.drive.business.event.FileVirusScanCleanEvent;
import de.justsoftware.drive.business.event.FilesCreatedEvent;
import de.justsoftware.drive.business.event.NewFileVersionUploadedEvent;
import de.justsoftware.drive.business.file.FilePreviewService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.file.FileVersionPreviewDAO;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
@ParametersAreNonnullByDefault
public class FilePreviewQueueServiceImpl {
    private static final int FETCH_FROM_QUEUE_THRESHOLD = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(FilePreviewQueueServiceImpl.class);
    private final int _batchSize;
    private final FileVersionPreviewDAO _previewDAO;
    private final FilePreviewService _filePreviewService;
    private final FileService _fileService;
    private final SettingsService _settingsService;
    private final ItemReadService _itemReadService;

    @Autowired
    public FilePreviewQueueServiceImpl(FilePreviewService filePreviewService, FileVersionPreviewDAO previewDAO, FileService fileService, @Value(value="${just.drive.previews.queue.batchsize:100}") int batchSize, EventBus eventBus, SettingsService settingsService, ItemReadService itemReadService) {
        this._filePreviewService = filePreviewService;
        this._previewDAO = previewDAO;
        this._fileService = fileService;
        this._batchSize = batchSize;
        this._settingsService = settingsService;
        this._itemReadService = itemReadService;
        eventBus.register((Object)this);
    }

    @Scheduled(fixedDelayString="${just.drive.previews.queue.delay:600000}", initialDelay=0L)
    public void createPreviews() {
        StopWatch watch = new StopWatch("createPreviews -  batchSize: " + this._batchSize);
        watch.start("loading ids from queue");
        List queuedIds = this._previewDAO.getNextQueueEntries(this._batchSize);
        watch.stop();
        if (watch.getLastTaskTimeMillis() > 1000L) {
            LOG.warn("loading of queued entries took {} milliseconds", (Object)watch.getLastTaskTimeMillis());
        }
        if (queuedIds.isEmpty()) {
            return;
        }
        watch.start("processing entries: " + queuedIds.size());
        ImmutableMap queuedVersions = this._fileService.getVersionsByIds((Set)ImmutableSet.copyOf((Collection)queuedIds));
        ImmutableList files = ImmutableList.copyOf((Collection)queuedVersions.values());
        ItemId itemId = ((FileVersionBO)files.get(0)).getItemId();
        ItemBO item = this._itemReadService.findItem(itemId);
        if (item == null || item.getTenantId() == null) {
            this._filePreviewService.requestFilePreview((List)files);
        } else if (this._settingsService.isAntivirusEnabled(item.getTenantId())) {
            List cleanFiles = files.stream().filter(f -> f.getVirusScanStatus() == VirusScanStatus.CLEAN).collect(Collectors.toList());
            if (cleanFiles.isEmpty()) {
                return;
            }
            this._filePreviewService.requestFilePreview(cleanFiles);
        }
        watch.stop();
        LOG.debug(watch.prettyPrint());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFileCreated(FilesCreatedEvent event) {
        this.createPreview(event.getDocumentVersions());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFileCreated(NewFileVersionUploadedEvent event) {
        this.createPreview(event.getDocumentVersions());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onVirusScanCompleted(FileVirusScanCleanEvent event) {
        this.createPreview(event.getDocumentVersions());
    }

    private void createPreview(ImmutableMap<DocumentId, DocumentVersionId> event) {
        ImmutableCollection documentVersionIds = event.values();
        LOG.debug("Creating preview for DocumentVersionId {}", (Object)documentVersionIds);
        ImmutableMap versionsWithFileInfos = this._fileService.getVersionsByIds((Set)ImmutableSet.copyOf((Collection)documentVersionIds));
        this._filePreviewService.requestFilePreview((List)ImmutableList.copyOf((Collection)versionsWithFileInfos.values()));
    }
}

