/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.common;

import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.util.CommandLineResult;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J*\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0012\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\"\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001bJ*\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 \u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Lde/justsoftware/justdocumentz/common/ContainerManageService;", "", "()V", "createContainer", "", "containerName", "", "podmanConfig", "Lde/justsoftware/justdocumentz/config/PodmanConfig;", "arguments", "", "imageName", "timeout", "Lkotlin/time/Duration;", "createContainer-9VgGkz4", "(Ljava/lang/String;Lde/justsoftware/justdocumentz/config/PodmanConfig;Ljava/util/List;Ljava/lang/String;J)V", "isContainerRunning", "", "readUntil", "process", "Ljava/lang/Process;", "targetText", "readUntil-SxA4cEA", "(Ljava/lang/Process;Ljava/lang/String;J)Z", "startContainer", "Lde/justsoftware/justdocumentz/util/CommandLineResult;", "startContainer-HG0u8IE", "(Ljava/lang/String;J)Lde/justsoftware/justdocumentz/util/CommandLineResult;", "stopContainer", "stopContainer-HG0u8IE", "waitForContainerLog", "waitForContainerLog-SxA4cEA", "(Ljava/lang/String;Ljava/lang/String;J)Z", "just-documentz"})
public class ContainerManageService {
    public boolean isContainerRunning(@NotNull String containerName) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Object[] objectArray = new String[]{"podman", "ps", "--filter", "name=" + containerName, "--format", "{{.Names}}"};
        List command = CollectionsKt.listOf((Object[])objectArray);
        CommandLineResult result = CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)command, (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)), (boolean)false, null, (int)12, null);
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)result.getOutput())).toString(), (Object)containerName);
    }

    public void createContainer-9VgGkz4(@NotNull String containerName, @NotNull PodmanConfig podmanConfig, @NotNull List<String> arguments, @NotNull String imageName, long timeout) {
        List list;
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Intrinsics.checkNotNullParameter((Object)podmanConfig, (String)"podmanConfig");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        List $this$createContainer_9VgGkz4_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object[] objectArray = new String[]{"podman", "create", "--name", containerName, "--pull", "never"};
        $this$createContainer_9VgGkz4_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        $this$createContainer_9VgGkz4_u24lambda_u240.addAll(CommandLineUtilsKt.toArgs((PodmanConfig)podmanConfig));
        $this$createContainer_9VgGkz4_u24lambda_u240.addAll((Collection)arguments);
        $this$createContainer_9VgGkz4_u24lambda_u240.add(imageName);
        CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)CollectionsKt.build((List)list), (Duration)Duration.box-impl((long)timeout), (boolean)false, null, (int)12, null);
    }

    @NotNull
    public CommandLineResult startContainer-HG0u8IE(@NotNull String containerName, long timeout) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Object[] objectArray = new String[]{"podman", "start", containerName};
        return CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)CollectionsKt.listOf((Object[])objectArray), (Duration)Duration.box-impl((long)timeout), (boolean)false, null, (int)12, null);
    }

    @NotNull
    public CommandLineResult stopContainer-HG0u8IE(@NotNull String containerName, long timeout) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Object[] objectArray = new String[]{"podman", "stop", "--time", String.valueOf(Duration.getInWholeSeconds-impl((long)timeout)), containerName};
        return CommandLineUtilsKt.executeCommandLine-hhJSO8g$default((List)CollectionsKt.listOf((Object[])objectArray), (Duration)Duration.box-impl((long)Duration.plus-LRDsOJo((long)timeout, (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS))), (boolean)false, null, (int)12, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForContainerLog-SxA4cEA(@NotNull String containerName, @NotNull String targetText, long timeout) {
        Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
        Intrinsics.checkNotNullParameter((Object)targetText, (String)"targetText");
        Object[] objectArray = new String[]{"podman", "logs", "-f", containerName};
        List command = CollectionsKt.listOf((Object[])objectArray);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        try {
            Intrinsics.checkNotNull((Object)process);
            boolean bl = this.readUntil-SxA4cEA(process, targetText, timeout);
            return bl;
        }
        finally {
            if (process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    private boolean readUntil-SxA4cEA(Process process, String targetText, long timeout) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < Duration.getInWholeMilliseconds-impl((long)timeout)) {
            if (reader.ready()) {
                String line = reader.readLine();
                if (line == null || !StringsKt.contains$default((CharSequence)line, (CharSequence)targetText, (boolean)false, (int)2, null)) continue;
                return true;
            }
            if (!process.isAlive()) break;
            Thread.sleep(500L);
        }
        return false;
    }
}

